/****************************************************************************
*
* (C) 1999 by BECK IPC GmbH
*
*  BECK IPC GmbH
*  Garbenheimerstr. 38
*  D-35578 Wetzlar
*
*  Phone : (49)-6441-905-240
*  Fax   : (49)-6441-905-245
*
* ---------------------------------------------------------------------------
* Module      : CountCGI.c
*
* Function    : This program demonstrates the usage of the implemented
				CGI-Interface of IPC@CHIP in a dos program.
				The programmer should use this program as an example
				for building own cgi functions

				Compiler     : Borland C 3.0
				Projectfile  : CountCGI.prj
				Memorymodell : Large


				Compiler     : Microsoft Visual C V1.52
				Projectfile  : CountCGI.mak
				Memorymodel  : Large



				Important for the usage of Microsoft C-Compiler:

				1. Use as struct member byte aligment: 1Byte !!!!!
				or #pragma pack(1) and #pragma check_stack( off )

				2. Cgi functions must be declared as the following:
				void far _saveregs _loadds _pascal Example1_Func(rpCgiPtr CgiRequest);


				3. Microsoft C compiler will not accept the follwing statements
				   from  the main function:

				   inregs.x.dx   = FP_SEG(&example);
				   inregs.x.si   = FP_OFF(&example);

				   because example is a structure, we changed it:

				   //declare a pointer of type CGI_ENTRY
				   CGI_Entry  * cgiptr;



				   cgiptr =  &example;
				   inregs.h.ah   = CGI_INSTALL;
				   inregs.x.dx   = FP_SEG(cgiptr);
				   inregs.x.si   = FP_OFF(cgiptr);




				At this example, we placed a error directive define,
				if memory model large is not used.




				Note:
				Before testing this example, the directory "web" and
				the file "index.htm" should be exist at the IPC@CHIP.
				This could be done with FTP or via the serial port.

				Description:

				At the start of the programm, we set the current
				root directory of the webserver to the directory
				"web" and set a new mainpage name "index.htm".

				This is only for to demonstrate this features,
				it's not important for the working of the program.

				After doing that, the webserver searches for all
				requested files at this directory.
				A browserrequest with the '/' e.g. http://192.168.205.4/
				is (from now on)  answered from the server with the new
				mainpagefile "index.htm" at the root directory "web".




				Further we install a cgi function, which produces a
				dynamic htmlpage in the memory. This page has the name
				"example2". The name if the installed cgi function
				is "example_func2". The expected http method is "get".

				If a browserrequest e.g. http://192.168.205.4/countcgi
				comes in, the web server calls this function.
				At the mainloop of our program, we increment a counter
				once per second.

				The called function builds a string, which contains
				a small html page with the actual value of our counter.

				During runtime of the program, the page "countcgi"
				can be loaded from a browser.


				After two minutes the program ends.
				A browserrequest after the end of the program
				returns "Object not found, ......"

				Important:
				At the end of the program we must remove the installed
				cgi function from webservers CGI table.



* Author        : Bartat
* Date          : 13.11.99
* Version       : V1.00
* ---------------------------------------------------------------------------
* History       :
*
*  Vx.yy        Author  Changes
*
*  V1.00          mb    Create
*  V1.01          mb    add cgi func declaration for Microsoft C
*  V1.02          mb    change declaration of cgi funcs to pascal
*  V1.03          mb    Replaced "" with \" at html strings
*****************************************************************************/

/****************************************************************************/
/* includes
/****************************************************************************/


#include <DOS.H>
#include <STDIO.H>
#include <STRING.H>


/****************************************************************************/
/* Compiler dependent defines, Microsoft C V152 */
/****************************************************************************/
#ifdef _MSC_VER

  //set structure member assignment to 1Byte !!!!
  #pragma pack(1)
  #pragma check_stack( off )

  #ifndef _M_I86LM
	#error Must use LARGE memory model
  #endif

#endif /* _MSC_VER */

/****************************************************************************/
/* API includes
/****************************************************************************/

//needed for sleep call
#include "TCPIPAPI.H"
//cgi types, constants, ...
#include "CGI.H"
/*************************************************************************/
//defines
/*************************************************************************/
//needed interrupt vectors
#define TCPIPVECT     0xAC
#define CGIVECT       0xAB


#define MAIN_LOOPS    120L   /* our program run MAIN_LOOPS seconds*/
/****************************************************************************/
//needed registerstructs for CGI interrupt calls
/****************************************************************************/
static union  REGS  inregs;
static union  REGS  outregs;
static struct SREGS segregs;

/****************************************************************************/
// we set the name "index.htm" as main page name
// this means: if a browserrequest  e.g. http://192.168.205.4/ occurs
//             the webserver  returns the file "index.htm"
/****************************************************************************/
char * MainpageName = "index.htm";

/****************************************************************************/
// we set the directory "web" as root directory
/****************************************************************************/
char * WebRootDirectory = "web";

/***************************************************************************
  the name of the page for the browserrequest
  e.g. http://192.168.200.5/countcgi
****************************************************************************/
char * HtmlPageName     = "countcgi";
/***************************************************************************
//our cgi entry webserver
 ***************************************************************************/
CGI_Entry   example;
//microsoft Visual C need this
CGI_Entry   * cgiptr;

//the loop counter
unsigned long MainLoopCounter = 0L;

/***************************************************************************
Predefine head and tail of our page
***************************************************************************/
char * PageHead = "<HTML><HEAD><TITLE>IPC@CHIP CGI example2</TITLE></HEAD>"
				  "<BODY BGCOLOR=\"#A0A0A0\">"
				  "<IMG SRC=\"beck.gif\" ALIGN=\"RIGHT\" ALT=\"BECK\">"
				  "<BR><BR>"
				  "<CENTER>"
				  "<H1>IPC@CHIP CGI example2</H1>"
				  "<HR size=0>"
				  "<FONT FACE=\"Courier\" SIZE=+2>";



char * PageEnd = "</FONT>"
				 "<HR size=0>"
				 "<p align=center><SMALL><EM>&copy BECK IPC GmbH, 1999</EM>"
				 "</BODY>"
				 "</HTML>";

/***************************************************************************
we store at the cgi function our page in this buffer
***************************************************************************/

char HtmlPage[512];


/****************************************************************************
	CGI function, the webserver executes this function, if a
	browser request e.g. http://192.168.200.8/example2 comes in,
	We build at this function a new html page in memory, including
	the current counter value of the main loop
	At the end of this function we tell the webserver the address
	of our buffer and its length.
	The webserver sends this buffer back to the browser

****************************************************************************/
//Microsoft Visual C
#ifdef _MSC_VER
void far _saveregs _loadds _pascal Example2_Func(rpCgiPtr CgiRequest)
#else
void huge _pascal Example2_Func(rpCgiPtr CgiRequest)
#endif
{

   char tmpbuffer[80];


   /**********************************/
   //building the page
   /**********************************/

   //insert the head of the page
   strcpy(HtmlPage,PageHead);

   //get main loop counter
   sprintf(tmpbuffer,"<BR>Main loop counter %ld<BR>",MainLoopCounter);
   strcat(HtmlPage,tmpbuffer);

   //append the predefined tail
   strcat(HtmlPage,PageEnd);

   /**********************************/
   //give it to the webserver
   /**********************************/

   CgiRequest->fHttpResponse         = CgiHttpOk;
   CgiRequest->fResponseBufferPtr    = HtmlPage;
   CgiRequest->fResponseBufferLength = strlen(HtmlPage);

}
/****************************************************************************/
int main(void)
{


   printf("\r\nStarting CGI example2\r\n\r\n");
   #ifdef _MSC_VER
   printf("Microsoft C\r\n");
   #endif

   /********************************/
   //Set mainpage name
   /********************************/
   inregs.h.ah   = CGI_SETMAIN;
   inregs.x.dx   = FP_SEG(MainpageName);
   inregs.x.si   = FP_OFF(MainpageName);
   int86(CGIVECT,&inregs,&outregs);

   if(outregs.x.dx == (unsigned int)CGI_ERROR)
   {
	  printf("\r\nSetting mainpage %s failed\r\n",MainpageName);
   }


   /********************************/
   //Set  webservers rootdirectory
   /********************************/
   inregs.h.ah   = CGI_SETROOTDIR;
   inregs.x.dx   = FP_SEG(WebRootDirectory);
   inregs.x.si   = FP_OFF(WebRootDirectory);
   int86(CGIVECT,&inregs,&outregs);

   if(outregs.x.dx == (unsigned int)CGI_ERROR)
   {
	  printf("\r\nSetting root directory %s failed\r\n",WebRootDirectory);
   }


   /********************************/
   //Get mainpage name
   /********************************/
   inregs.h.ah   = CGI_GETMAIN;
   int86x(CGIVECT,&inregs,&outregs,&segregs);
   printf("\r\nMainpage      : %s",(char *)MK_FP(segregs.es,outregs.x.di));


   /********************************/
   //Get root directory
   /********************************/
   inregs.h.ah   = CGI_GETROOTDIR;
   int86x(CGIVECT,&inregs,&outregs,&segregs);
   printf("\r\nRoot directory: %s\r\n",(char *)MK_FP(segregs.es,outregs.x.di));





   /********************************/
   //install example cgi function
   /********************************/

   //init CGI_entry example;
   example.PathPtr    = HtmlPageName;    //name of the page
   example.method     = CgiHttpGet;      //method
   example.CgiFuncPtr = Example2_Func;   //function



   cgiptr =  &example;

   // We need this helpptr because the Microsoft compiler
   // will not accept the following:
   // inregs.x.dx   = FP_SEG(&example);
   // inregs.x.si   = FP_OFF(&example);

   inregs.h.ah   = CGI_INSTALL;
   inregs.x.dx   = FP_SEG(cgiptr);
   inregs.x.si   = FP_OFF(cgiptr);


   int86(CGIVECT,&inregs,&outregs);

   if(outregs.x.dx == (unsigned int)CGI_ERROR)
   {

	  printf("\r\nInstalling CGI function %s failed --> exit program\r\n",example.PathPtr);
	  return 0;
   }



   /*******************************************************************/
   //Main loop: Increment a counter
   //
   /*******************************************************************/
   while(MainLoopCounter < MAIN_LOOPS)
   {

	   //increcment the counter for our dynamic html page
	   MainLoopCounter++;

	   //sleep a second
	   inregs.h.ah = API_SLEEP;
	   inregs.x.bx = 1000; //milliseconds
	   int86(TCPIPVECT,&inregs,&outregs);
   }

   /***************************************/
   //Important: remove example cgi function
   /***************************************/

   inregs.h.ah   = CGI_REMOVE;
   inregs.x.dx   = FP_SEG(example.PathPtr);
   inregs.x.si   = FP_OFF(example.PathPtr);
   int86(CGIVECT,&inregs,&outregs);

   if(outregs.x.dx == (unsigned int)CGI_ERROR)
   {

	  printf("\r\nRemoving %s failed\r\n",example.PathPtr);
	  return 0;
   }


   printf("\r\nExit program\r\n");

   return 0;
}
/*************************************************************************/
//end example2.c
/*************************************************************************/
