/****************************************************************************
*  Second Tst Version
* (C) 1999 by BECK IPC GmbH
*
*  BECK IPC GmbH
*  Garbenheimerstr. 38
*  D-35578 Wetzlar
*
*  Phone : (49)-6441-905-240
*  Fax   : (49)-6441-905-245
*
* ---------------------------------------------------------------------------

$Header: CGI.H, 3, 24.01.01 10:36:01, Christoph Stoidner$


* Function      : access to webservers cgi
*
*
* Author        : Bartat
* Date          : 05.11.99
* Version       : V1.00
* ---------------------------------------------------------------------------
* History       :
*
*  Vx.yy            Author  Changes
*
*  V1.00               mb    Create
*  V1.01  12.01.00     mb    added func getformitem
*  V1.01  04.04.00     mb    added new mimetype defines
*                            ,available at SC12 BIOS V0.65
*                            added cgi install func for Pascal CGI procedures

$Log: 
 3    Projekte Software1.2         24.01.01 10:36:01    Christoph Stoidner
      modify comment header
 2    Projekte Software1.1         24.01.01 10:33:48    Christoph Stoidner
      modified struct rpcgi request (use old fuserptr now as remoteip ptr)
 1    Projekte Software1.0         15.12.00 15:25:34    Andre Pribil    
$

*****************************************************************************/
#ifndef _CGI_H__
#define _CGI_H__

/*****************************************************************************/
//CGI defines
/*****************************************************************************/

//Cgi HTTP requests
#define CgiHttpGet  1       /*  Cgi request is HTTP GET  */
#define CgiHttpHead 2       /*  Cgi request is HTTP HEAD */
#define CgiHttpPost 3       /*  Cgi request is HTTP POST */


//Cgi HTTP responses
#define    CgiHttpOk            0 /*  Cgi returns HTTP 200 Ok                 */
#define    CgiHttpOkStatic      1 /*  Cgi returns HTTP 200 Ok - Static Object */
#define    CgiHttpRedirect      2 /*  Cgi returns HTTP 302 Moved Temp         */
#define    CgiHttpNotModified   3 /*  Cgi returns HTTP 304 Not Modified       */
#define    CgiHttpUnauthorized  4 /*  Cgi returns HTTP 401 Unauthorized       */
#define    CgiHttpNotFound      5 /*  Cgi returns HTTP 404 Not Found          */
#define    CgiHttpOKNoDoc       6  /* Cgi returns HTTP 204 No document follows*/


//CGI constants for content types ,fDatatype

#define  CGIDataTypeHtml         0       /* CGI returns  text/html */
#define  CGIDataTypeImageGif     1       /* image/gif */
#define  CGIDataTypeApplet       2       /* application/octet-stream */
#define  CGIDataTypeText         3       /* text/plain */
#define  CGIDataTypeImageJpeg    4       /* image/jpeg */
#define  CGIDataTypeImagePict    5       /* image/pict */
#define  CGIDataTypeImageTiff    6       /* image/tiff */
#define  CGIDataTypeImagePng     7       /* image/png  */
#define  CGIDataTypeForm         8       /* application/x-www-form-urlencoded */
#define  CGIDataTypeIpp          9       /* application/ipp */
#define  CGIDataTypeCss         10       /* text/css */
#define  CGIDataTypeXml         11       /* text/xml */
#define  CGIDataTypeWav         12       /* audio/wav */
#define  CGIDataTypePdf         13       /* application/pdf */
#define  CGIDataTypeJavaArchive 14       /* application/java-archive */
#define  CGIDataTypeOctet       15       /* application/octet-stream */
#define  CGIDataTypeVndWapWml        16  /* text/vnd.wap.wml */
#define  CGIDataTypeVndWapWbmp       17  /* image/vnd.wap.wbmp  */
#define  CGIDataTypeVndWapWmlc       18  /* application/vnd.wap.wmlc */
#define  CGIDataTypeVndWapWmlscript  19  /* text/vnd.wap.wmlscript   */
#define  CGIDataTypeVndWapWmlscriptc 20  /* text/vnd.wap.wmlscriptc  */


/*****************************************************************************/
//Cgi API calls
/*****************************************************************************/
#define CGI_INSTALL      1     /* Install a cgi function */
#define CGI_REMOVE       2     /* Delete a cgi function  */
#define CGI_SETMAIN      3     /* Set new main page name  */
#define CGI_SETROOTDIR   4     /* Set webservers root directory */
#define CGI_GETROOTDIR   5     /* Get webservers root directory */
#define CGI_GETMAIN      6     /* Get name of main page*/
#define CGI_GETFORMITEM  7     /* Split argumentbuf into formular name and value*/
#define CGI_FINDNEXTITEM 8     /* Find next formitem, if one */
#define CGI_INSTALL_PAS  9     /* Install a Turbo Pascal cgi procedure */


/*****************************************************************************/
//CGI API general Errorcodes
/*****************************************************************************/
#define CGI_NOT_SUPPORTED       -2
#define CGI_ERROR               -1
#define CGI_ENOERROR             0

/*****************************************************************************/
//CGI API special Errorcodes, returned at the ax-register
/*****************************************************************************/

#define CGI_INVALID_METHOD       -1
#define CGI_INVALID_NAME         -2
#define CGI_INVALID_DIR          -3
#define CGI_NO_FREE_ENTRY        -4
#define CGI_NOT_FOUND            -5


/*****************************************************************************/
//types
/*****************************************************************************/
typedef struct tag_cgi_table{

            char     * PathPtr;   //name of the page
			int      method;      //httpmethod: get or post
            void     *  CgiFuncPtr;  //ptr to callback function of this page
}CGI_Entry;



/*
   this type is needed, if the function CGI_GETFORMITEM will be used,
   the user must set the pointers of the structure
   to his own buffers look at example submit.c.
*/

typedef struct tag_form_item{

            char * NamePtr;
            char * ValuePtr;
}FormItem;



/*
   the called cgi function gets as a parmeter
   a pointer of the following structure, which contains
   the needed http-request data and response data
*/

typedef struct {

    //Request fields, read only!!!!

    unsigned char       fConnectionId;         // internal use only
    int                 fHttpRequest;          // internal use only
    char *              fPathPtr;              //  URL
    char *              fHostPtr;              //  Host:
    char *              fRefererPtr;           //  Referer:
    char *              fAgentPtr;             //  User-Agent:
    char *              fLanguagePtr;          //  Content-Language:
    unsigned long       fBrowserDate;          //  Date:   (internal)
    char *              fArgumentBufferPtr;    //  Pointer at argument buffer
    long                fArgumentBufferLength; //  length of argument buffer, -1 buffer empty
    char *              fUserNamePtr;          //  Username from Authorization
    char *              fPasswordPtr;          //  Password from Authorization


    long *              fRemoteIPPtr;          //  Pointer to RemoteIP in wrong byte order
                                               //  , do not modify

    //Response fields,

    int                 fResponseState;          // internal, do not modify
    int                 fHttpResponse;           // response msg mostly CgiHttpOK
    int                 fDataType;               // content type mostly text/html
    char *              fResponseBufferPtr;      // pointer to created dynamic html page
    long                fResponseBufferLength;   // length of the created page
    unsigned long       fObjectDate;             // internal, do not modify
    unsigned int        fHostIndex;              // internal, do not modify
} rpCgi, *rpCgiPtr;
/*****************************************************************************/
#endif /*_CGI_H__*/
