/****************************************************************************
*
* (C) 1999 by BECK IPC GmbH
*
*  BECK IPC GmbH
*  Garbenheimerstr. 38
*  D-35578 Wetzlar
*
*  Phone : (49)-6441-905-240
*  Fax   : (49)-6441-905-245
*
* ---------------------------------------------------------------------------
* Module      : dk40cgi.c
*
* Function    :
		  This program demonstrates the usage of the implemented
		  CGI-Interface of IPC@CHIP in a dos program.
		  This example return a simple page with the status of the
		  I/O of the DK40. The real value is shown
		  when used together with Java !

		  The programmer should use this program as an example
		  for building own cgi functions.

		  Compiler     : Borland C 4.52
		  Projectfile  : dk40cgi.ide
		  Memorymodel  : Large


		  The name of the CGI page is "dk40" (warning: case sensitive !)

		  If a browserrequest e.g. http://192.168.205.4/dk40
		  comes in, the web server calls this function.



* Author        : schloesser
* Date          : 9.11.99
* Version       : V1.00
* ---------------------------------------------------------------------------
* History       :
*
*  Vx.yy        Author  Changes
*
*  V1.00          es    Create
*  V1.01          mb    Change cgi func declaration to pascal type
*  V1.02          mb    Replaced "" with \" at html strings
*  V1.03          mb    init chip selects  with the hardware API (BIOS V067)
*                        for access to port 0x600 of the DK40,
*                        using compiler borland 5.02
*
*****************************************************************************/
#include <DOS.H>
#include <STDIO.H>
#include <STRING.H>
//needed for sleep call
#include "TCPIPAPI.H"
//cgi types, constants, ...
#include "CGI.H"
/*************************************************************************/
//defines
/*************************************************************************/
//needed interrupt vectors
#define TCPIPVECT     0xAC
#define CGIVECT       0xAB


static int io_mask=0; // bits set if output

/***************************************************************************
  the name of the page for the browserrequest
  e.g. http://192.168.200.5/dk40
****************************************************************************/
char * HtmlPageName     = "dk40";
/***************************************************************************
//our cgi entry webserver
 ***************************************************************************/
CGI_Entry   example;
/***************************************************************************
Predefine head and tail of our page
***************************************************************************/
char * PageHead = "<HTML><HEAD><TITLE>IPC@CHIP CGI DK40</TITLE></HEAD>"
				  "<BODY BGCOLOR=\"#A0A0A0\">"
				  "<BR>"
				  "<H1>IPC@CHIP CGI DK40</H1>"
				  "<FONT SIZE=+2>";



char * PageEnd = "</FONT>"
				 "<HR size=0>"
				 "<p align=center><SMALL><EM>&copy BECK IPC GmbH, 1999</EM>"
				 "</BODY>"
				 "</HTML>";

/***************************************************************************
we store at the cgi function our page in this buffer
***************************************************************************/

char HtmlPage[512];


/****************************************************************************
	CGI function, the webserver executes this function, if a
	browser request e.g. http://192.168.200.8/dk40 comes in,
	We build at this function a new html page in memory, including
	the current io values of the the DK40
	At the end of this function, we tell the webserver the address
	of our buffer and its length.
	The webserver sends this buffer back to the browser

	Important: A CGI_function must be declared as huge
****************************************************************************/
void huge _pascal DK40_Func(rpCgiPtr CgiRequest)
{
	int  i;
	char tmpbuffer[80];
	int  val;

	/**********************************/
   //building the page
   /**********************************/

   //insert the head of the page
   strcpy(HtmlPage,PageHead);

   val=inport(0x0600);  // read the dk40 i/o port
   sprintf(tmpbuffer,"<BR>IO=0x%04X<BR>",val & 0x00FF);
   strcat(HtmlPage,tmpbuffer);

   for (i=0; i<7; i++)
   {
	 if (io_mask&(1<<i)) // is it an output ?
	   sprintf(tmpbuffer,"<BR>O%d=%d",i,(val&(1<<i)) ? 1 : 0);
	 else
	   sprintf(tmpbuffer,"<BR>I%d=%d",i,(val&(1<<i)) ? 1 : 0);
	 strcat(HtmlPage,tmpbuffer);
   }
   strcat(HtmlPage,"<BR>");

   //append the predefined tail         
   strcat(HtmlPage,PageEnd);

   /**********************************/
   //give it to the webserver
   /**********************************/

   CgiRequest->fHttpResponse         = CgiHttpOk;
   CgiRequest->fResponseBufferPtr    = HtmlPage;
   CgiRequest->fResponseBufferLength = strlen(HtmlPage);

}
/****************************************************************************/
int main(void)
{
  static union  REGS  inregs;
  static union  REGS  outregs;


   printf("\r\nStarting DK40 CGI Example\r\n\r\n");


   //init chip selects  with the hardware API
   inregs.h.ah=0x83;
   inregs.x.dx=0x40;
   int86(0xA2,&inregs,&outregs);



   /********************************/
   //install example cgi function
   /********************************/

   //init CGI_entry example;
   example.PathPtr    = HtmlPageName;    //name of the page
   example.method     = CgiHttpGet;      //http method
	example.CgiFuncPtr = DK40_Func;       //function


   inregs.h.ah   = CGI_INSTALL;
   inregs.x.dx   = FP_SEG(&example);
   inregs.x.si   = FP_OFF(&example);

   int86(CGIVECT,&inregs,&outregs);

   if(outregs.x.dx == (unsigned int)CGI_ERROR)
   {

 	  printf("\r\nInstalling CGI function %s failed --> exit program\r\n",example.PathPtr);
      return;
   }



   /*******************************************************************/
   //Main loop: Do nothing at all
   //
   /*******************************************************************/
   while(1)
   {
       //sleep a second
       inregs.h.ah = API_SLEEP;
       inregs.x.bx = 1000; //milliseconds
       int86(TCPIPVECT,&inregs,&outregs);
   }

}
/*************************************************************************/
//end dk40cgi.c
/*************************************************************************/
