/****************************************************************************
*
* (C) 1999 by BECK IPC GmbH
*
*  BECK IPC GmbH
*  Garbenheimerstr. 38
*  D-35578 Wetzlar
*
*  Phone : (49)-6441-905-240
*  Fax   : (49)-6441-905-245
*
* ---------------------------------------------------------------------------
* Module      : dk40_set.c
*
* Function    :
		  This program demonstrates the usage of the implemented
		  CGI-Interface of IPC@CHIP in a dos program.
		  This example returns a simple page with 14 links, which
		  allows per click to set or reset the DK40 IO pins 0-6


		  The programmer should use this program as an example
		  for building own cgi functions.

		  Compiler     : Borland C 4.52
		  Projectfile  : dk40_set.ide
		  Memorymodel  : Large


		  The name of the CGI page is "dk40_set" (warning: case sensitive !)

		  If a browserrequest e.g. http://192.168.205.4/dk40_set
		  comes in, the web server calls this function.



* Author        : bartat
* Date          : 10.11.99
* Version       : V1.00
* ---------------------------------------------------------------------------
* History       :
*
*  Vx.yy        Author  Changes
*
*  V1.00          mb    Create
*  V1.01          mb    Change cgi func declaration to pascal type
*  V1.02          mb    Replaced "" with \" at html strings
*  V1.03          mb    init chip selects  with the hardware API (BIOS V067)
                        for access to port 0x600 of the DK40,
                        using compiler borland 5.02
*****************************************************************************/


#include <DOS.H>
#include <STDIO.H>
#include <STRING.H>
//needed for sleep call
#include "TCPIPAPI.H"
//cgi types, constants, ...
#include "CGI.H"
/*************************************************************************/
//defines
/*************************************************************************/
//needed interrupt vectors
#define TCPIPVECT     0xAC
#define CGIVECT       0xAB


unsigned char old_outval=0;

/***************************************************************************
  the name of the page for the browserrequest
  e.g. http://192.168.200.5/dk40_set
****************************************************************************/
char * HtmlPageName     = "dk40_set";
/***************************************************************************
//our cgi entry webserver
 ***************************************************************************/
CGI_Entry   example;
/***************************************************************************
Predefine  our page
***************************************************************************/
char * HtmlPage = "<HTML><HEAD><TITLE>IPC@CHIP CGI DK40</TITLE></HEAD>"
						"<BODY BGCOLOR=\"#A0A0A0\">"
						"<BR>"
						"<CENTER>"
						"<H1>IPC@CHIP CGI DK40</H1>"
                  "<HR size=0>"
						"<FONT FACE = \"Courier\" SIZE=+1>"
						"<P>Pin 0:  <A HREF=\"dk40_set?01\">Set</A>       "
						"   <A HREF=\"dk40_set?00\">Reset</A></P>"
						"<P>Pin 1:  <A HREF=\"dk40_set?11\">Set</A>       "
						"   <A HREF=\"dk40_set?10\">Reset</A></P>"
						"<P>Pin 2:  <A HREF=\"dk40_set?21\">Set</A>       "
						"   <A HREF=\"dk40_set?20\">Reset</A></P>"
						"<P>Pin 3:  <A HREF=\"dk40_set?31\">Set</A>       "
						"   <A HREF=\"dk40_set?30\">Reset</A></P>"
						"<P>Pin 4:  <A HREF=\"dk40_set?41\">Set</A>       "
						"   <A HREF=\"dk40_set?40\">Reset</A></P>"
						"<P>Pin 5:  <A HREF=\"dk40_set?51\">Set</A>       "
						"   <A HREF=\"dk40_set?50\">Reset</A></P>"
						"<P>Pin 6:  <A HREF=\"dk40_set?61\">Set</A>       "
						"   <A HREF=\"dk40_set?60\">Reset</A></P>"
						"</FONT>"
						"<HR size=0>"
						"<p align=center><SMALL><EM>&copy BECK IPC GmbH, 1999</EM>"
                  "</CENTER>"
						"</BODY>"
						"</HTML>";

/****************************************************************************
	CGI function, the webserver executes this function, if a
	browser request e.g. http://192.168.200.8/dk40_set comes in,

	If the browserrequest is send without any arguments, we send
	the predefined page in memory (htmlpage).

	If there are valid arguments, we parse them, and set or reset the
	requested output of the dk40 and return no page.

	The  arguments are made simple:
				  00 means reset DK40 Output 0
				  01       set   DK40 Output  0
				  ...
				  61 means set   DK40 Output 6

****************************************************************************/
void huge _pascal DK40_Func(rpCgiPtr CgiRequest)
{
	int  bit;
	int  tmp;

	/**********************************/
	//check if there are arguments
	/**********************************/
	if(CgiRequest->fArgumentBufferLength==0L)
	{
	  //we send the page
	  CgiRequest->fHttpResponse         = CgiHttpOk;
	  CgiRequest->fResponseBufferPtr    = HtmlPage;
	  CgiRequest->fResponseBufferLength = strlen(HtmlPage);
	  return;
	}

	/**********************************/
	//parse the arguments
	/**********************************/
	if(CgiRequest->fArgumentBufferLength==2L)
	{
		tmp = CgiRequest->fArgumentBufferPtr[0] - 48;
		if((tmp>=0) && (tmp<7))
		{
			//read the current value
			old_outval = inportb(0x600);

			bit = tmp;
			tmp = CgiRequest->fArgumentBufferPtr[1] - 48;
			switch(tmp)
			{
				  case 0: old_outval &= ~(1<<bit);
							 outportb(0x600,old_outval);
							 break;

				  case 1: old_outval |=  1<<bit;
							 outportb(0x600,old_outval);
							 break;

				  default: break;
			}//switch(tmp)
		}//if((tmp>=0) && (tmp<7))
	 }
	/********************************************************************/
	//set HTTP 204 as http response, because we're sending no document
	/********************************************************************/
CGI_FUNC_FINISHED:
	  CgiRequest->fHttpResponse         = CgiHttpOKNoDoc;  //HTTP 204, no document
	  CgiRequest->fResponseBufferPtr    = NULL;
	  CgiRequest->fResponseBufferLength = 0L;
}
/****************************************************************************/
int main(void)
{
	static union  REGS  inregs;
	static union  REGS  outregs;


	printf("\r\nStarting DK40 CGI Example\r\n\r\n");

   //init chip selects  with the hardware API
   inregs.h.ah=0x83;
   inregs.x.dx=0x40;
   int86(0xA2,&inregs,&outregs);



	//set all DK40 outputs to zero
	outportb(0x600,0x00);
	/********************************/
	//install example cgi function
	/********************************/
	//init CGI_entry example;
	example.PathPtr    = HtmlPageName;    //name of the page
	example.method     = CgiHttpGet;      //http method
	example.CgiFuncPtr = DK40_Func;       //function


	inregs.h.ah   = CGI_INSTALL;
	inregs.x.dx   = FP_SEG(&example);
	inregs.x.si   = FP_OFF(&example);

	int86(CGIVECT,&inregs,&outregs);

	if(outregs.x.dx == (unsigned int)CGI_ERROR)
	{

	  printf("\r\nInstalling CGI function %s failed --> exit program\r\n",example.PathPtr);
		return;
	}



	/*******************************************************************/
	//Main loop: Do nothing at all
	//
	/*******************************************************************/
	while(1)
	{
		 //sleep a second
		 inregs.h.ah = API_SLEEP;
		 inregs.x.bx = 1000; //milliseconds
		 int86(TCPIPVECT,&inregs,&outregs);
	}

}
/*************************************************************************/
//end dk40_set.c
/*************************************************************************/
