/****************************************************************************
*
* (C) 1999 by BECK IPC GmbH
*
*  BECK IPC GmbH
*  Garbenheimerstr. 38
*  D-35578 Wetzlar
*
*  Phone : (49)-6441-905-240
*  Fax   : (49)-6441-905-245
*
* ---------------------------------------------------------------------------
* Module      : Submit2.c
*
* Function    :
				This program demonstrates the usage of the implemented
				CGI-Interface of IPC@CHIP in a dos program, especially
				the building of formulars and the usage of more than one item.

				The programmer should read and test first the example submit.c
				and use this program as an example	for building own cgi functions.


				Compiler     : Borland C 3.0
				Projectfile  : submit2.prj
				Memorymodel  : Large


* Author        : Bartat
* Date          : 27.01.00
* Version       : V1.00
* ---------------------------------------------------------------------------
* History       :
*
*  Vx.yy        Author  Changes
*
*  V1.00          mb    Create
*  V1.01          mb    Change cgi func declaration to pascal style
*  V1.02          mb    Replaced "" with \" at html strings
*****************************************************************************/

/****************************************************************************/
/* Compiler dependent defines, Microsoft C V152 */
/****************************************************************************/
#ifdef _MSC_VER

  //set structure member assignment to 1Byte !!!!
  #pragma pack(1)

  #ifndef _M_I86LM
	#error Must use LARGE memory model
  #endif

#endif /* _MSC_VER */

/****************************************************************************/
//includes
/****************************************************************************/
#include <DOS.H>
#include <STDIO.H>
#include <STRING.H>
#include <STDLIB.H>
//needed for sleep call
#include "TCPIPAPI.H"
//cgi types, constants, ...
#include "CGI.H"
#include "CGIAPI.H"
/*************************************************************************/
//constants
/*************************************************************************/
//needed interrupt vectors
#define TCPIPVECT     0xAC


#define MAIN_LOOPS    300L   /* our program run MAIN_LOOPS seconds*/
/***************************************************************************
  the name of the page for the browserrequest
  e.g. http://192.168.200.5/example1
****************************************************************************/
static char * HtmlPageName     = "submitexample_2";
static char * ProcessName      = "processform_2";
/***************************************************************************
//our cgi entry webserver
 ***************************************************************************/
static CGI_Entry   submitexample;
static CGI_Entry   processexample;

static unsigned long MainLoopCounter = 0L;

/***************************************************************************/
static char ProcessPageBuffer[2048];
/***************************************************************************/

/******************************/
//static Htmltext for submitexample
/******************************/

static char HtmlSubmitPage[] =

    "<HTML><HEAD><TITLE>IPC@Chip Form Page</TITLE></HEAD>"
    "<BODY BGCOLOR=\"#A0A0A0\">"
		"<IMG SRC=\"beck.gif\" ALIGN=\"RIGHT\" ALT=\"BECK\">"
		"<BR><BR>"
		"<CENTER>"
		"<H1>IPC@Chip Form Page</H1>"
		"<HR size=0>"
		"</CENTER>"
    "<P>"
	"<FORM ACTION=/processform_2 METHOD=POST>"
	"Enter something in the boxes "
	"<BR><BR><INPUT TYPE=TEXT NAME=\"Testtext1\" SIZE=15 MAXSIZE=15>"
	"<BR><BR><INPUT TYPE=TEXT NAME=\"Testtext2\" SIZE=15 MAXSIZE=15>"
    "<BR><BR>and <INPUT TYPE=SUBMIT NAME=\"Button\" VALUE=\"Submit\">"
    "</FORM>"
    "<HR size=0>"
		"<p align=center><SMALL><EM>&copy BECK IPC GmbH, 2000</EM>"
		"</BODY>"
		"</HTML>";




/****************************************************/
//static head and tail for processform
/*****************************************************/

static char  HtmlPageHead[] =

    "<HTML><HEAD><TITLE>IPC@Chip Form Page</TITLE></HEAD>"
    "<BODY BGCOLOR=\"#A0A0A0\">"
		"<IMG SRC=\"beck.gif\" ALIGN=\"RIGHT\" ALT=\"BECK\">"
		"<BR><BR>"
		"<CENTER>"
		"<H1>IPC@Chip Form Page</H1>"
		"<HR size=0>"
		"</CENTER>";

static char  HtmlPageTail[] =
    "<P>"
	"<P><A HREF=\"submitexample_2\">Back to submit page</A></P>"
    "<HR size=0>"
		"<p align=center><SMALL><EM>&copy BECK IPC GmbH, 2000</EM>"
		"</BODY>"
		"</HTML>";

/****************************************************************************
	CGI function, the webserver executes this function, if a
	browser request e.g. http://192.168.200.8/submitexample comes in,
	We return at this function a html page in memory, which
  contains the foolowing Form tag

  "<FORM ACTION=/processform METHOD=POST>"
  "Enter something in the box "
  "<INPUT TYPE=TEXT NAME=\"Testtext\" SIZE=15 MAXSIZE=15>"
  "<BR><BR>and <INPUT TYPE=SUBMIT NAME=\"Button\" VALUE=\"Submit\">"
  "</FORM>"

****************************************************************************/

//Microsoft Visual C
#ifdef _MSC_VER
void far _saveregs _loadds _pascal Submit_Func(rpCgiPtr CgiRequest)
#else
void huge _pascal Submit_Func(rpCgiPtr CgiRequest)
#endif
{


   //set response fields
   CgiRequest->fHttpResponse         = CgiHttpOk;       //HTTP 200 OK
   CgiRequest->fDataType             = CGIDataTypeHtml; //text/html

   CgiRequest->fResponseBufferPtr    = HtmlSubmitPage;  //page address

   CgiRequest->fResponseBufferLength = strlen(HtmlSubmitPage); //length of the page



}



/****************************************************************************
	CGI function, the webserver executes this function, if a
  the submit button was pressed at the page "submitexample"
  This function builds a page, which contains
****************************************************************************/


//Microsoft Visual C
#ifdef _MSC_VER
void far _saveregs _loadds _pascal Process_Func(rpCgiPtr CgiRequest)
#else
void huge _pascal   Process_Func(rpCgiPtr CgiRequest)
#endif
{

   char far     * FormNamePtr  = NULL;
   char far     * FormValuePtr = NULL;

   char far     * helpnext     = NULL;
   int result;
   FormItem far * formitem     = NULL;


   //Insert the head of the dynamic html page
   strcpy(ProcessPageBuffer,HtmlPageHead);

   if(strlen(CgiRequest->fArgumentBufferPtr))
   {
      //alloc memory
	  FormNamePtr=(char far *)malloc(sizeof(char )*50);
	  FormValuePtr=(char far *)malloc(sizeof(char )*250);
      formitem=(FormItem far *)malloc(sizeof(FormItem));

	  if((FormNamePtr!=NULL) && (FormValuePtr!=NULL) && (formitem!=NULL))
	  {
		formitem->NamePtr  = FormNamePtr;
		formitem->ValuePtr = FormValuePtr;

		CGI_GetFormItem(CgiRequest->fArgumentBufferPtr, formitem);


		strcat(ProcessPageBuffer,"<P><P>Formularname 1: ");
		strcat(ProcessPageBuffer,formitem->NamePtr);

		strcat(ProcessPageBuffer,"<P><P>Entered value1: ");
		strcat(ProcessPageBuffer,formitem->ValuePtr);



		/*
		   we expect two items from the page submitexample2,
		   so call  CGI_GETNEXTITEM item, and read it with
		   GET_FORMITEM
		*/
		result = CGI_GetNextItem(CgiRequest->fArgumentBufferPtr, &helpnext);
		if(result == 0)
		{
		  //helpnext points to the next formitem in the argumentbuffer
		  CGI_GetFormItem(helpnext, formitem);
		  strcat(ProcessPageBuffer,"<P><P>Formularname 2: ");
		  strcat(ProcessPageBuffer,formitem->NamePtr);
		  strcat(ProcessPageBuffer,"<P><P>Entered value2: ");
		  strcat(ProcessPageBuffer,formitem->ValuePtr);
		}


        //free memory
        free(FormNamePtr);
        free(FormValuePtr);
        free(formitem);
      }//
      else
      {
        strcat(ProcessPageBuffer,"<P>Webserver, memory allocation failed<P>");
      }
   }//if(strlen(CgiRequest->fArgumentBufferPtr))

   //Append the tail of the dynamic html page
   strcat(ProcessPageBuffer,HtmlPageTail);


   //set response fields
   CgiRequest->fHttpResponse         = CgiHttpOk;       //HTTP 200 OK
   CgiRequest->fDataType             = CGIDataTypeHtml; //text/html

   CgiRequest->fResponseBufferPtr    = ProcessPageBuffer; //page address
   CgiRequest->fResponseBufferLength = strlen(ProcessPageBuffer); //length



}


/****************************************************************************/

int main(void)
{

   int result;
   union  REGS  inregs;
   union  REGS  outregs;

   printf("\r\nInstalling CGI second submit example\r\n");
   #ifdef _MSC_VER
   printf("Microsoft C\r\n");
   #endif

   /***********************************/
   //install submitexample cgi function
   /***********************************/

   //init CGI_entry example;
   submitexample.PathPtr    = HtmlPageName;    //name of the page
   submitexample.method     = CgiHttpGet;      //method
   submitexample.CgiFuncPtr = Submit_Func;   //function


   result = CGI_Install(&submitexample);
   if(result == CGI_ERROR)
   {
	  //should not happen
	  printf("\r\nInstalling CGI function %s failed --> exit program\r\n",submitexample.PathPtr);
	  return 0;
   }

   /***********************************/
   //install process_form cgi function
   /***********************************/

   //init CGI_entry process;
   processexample.PathPtr     = ProcessName;    //name of the page
   processexample.method      = CgiHttpPost;      //method
   processexample.CgiFuncPtr  = Process_Func;   //function

   result = CGI_Install(&processexample);
   if(result == CGI_ERROR)
   {
	  //should not happen
	  printf("\r\nInstalling CGI function %s failed --> exit program\r\n",submitexample.PathPtr);
	  return 0;
   }


   /*******************************************************************/
   //Main loop: Increment a counter
   //
   /*******************************************************************/
   while(MainLoopCounter < MAIN_LOOPS)
   {

       //increcment the counter for our dynamic html page
       MainLoopCounter++;

       //sleep a second
       inregs.h.ah = API_SLEEP;
       inregs.x.bx = 1000; //milliseconds
       int86(TCPIPVECT,&inregs,&outregs);
   }

   /****************************************/
   //Important: remove example cgi function
   /****************************************/

   result = CGI_Delete(submitexample.PathPtr);
   if(result == CGI_ERROR)
   {

	  printf("\r\nRemoving %s failed\r\n",submitexample.PathPtr);
	  return 0;
   }
   printf("\r\n%s removed\r\n",submitexample.PathPtr);


   result = CGI_Delete(processexample.PathPtr);
   if(result == CGI_ERROR)
   {

	  printf("\r\nRemoving %s failed\r\n",processexample.PathPtr);
	  return 0;
   }
   printf("\r\n%s removed\r\n",processexample.PathPtr);

   printf("\r\nExit program\r\n");

   return 0;
}
/*************************************************************************/
//end submit.c
/*************************************************************************/
