/****************************************************************************
*
* (C) 1999 by BECK IPC GmbH
*
*  BECK IPC GmbH
*  Garbenheimerstr. 38
*  D-35578 Wetzlar
*
*  Phone : (49)-6441-905-240
*  Fax   : (49)-6441-905-245
*
* ---------------------------------------------------------------------------
* Module      : wapcgi.c
*
* Function    :
            This program demonstrates the usage of the implemented
				CGI-Interface of IPC@CHIP in a dos program.
				The programmer should use this program as an example
				for building own cgi functions.
            For a better understanding the programmer should first
            read the html documentation of the CGI API.


				Compiler     : Borland C++ 5.02
				Projectfile  : wapcgi.ide
				Memorymodel  : Large


				At this example, we placed a error directive define,
				if memory model large is not used.


				We install a cgi function, which
				produces a dynamic wmlpage in the memory.
				This page has the name "wapcgi". The name of the
				installed cgi function is "example_func1".
				The expected http method is "get".

				If a browserrequest e.g. http://192.168.205.4/wapcgi
				comes in, the web server calls this function.
				This function produces a wml pages, which contains
				the browser request data from the given parameter
				rpCGiPtr

				At the mainloop of our program, we increment a counter
				once per second. The program runs 2 minutes


				During runtime of the program, the page "wapcgi"
				can be loaded from a browser (WAP Handy).
            If your IPC@Chip has a valid static IP Address you can
            call the CGI function via a WAP Handy. For tests you can
            use a WAP Browser. By example "YourWap" (www.yourwap.com) 


				After two minutes the program ends.
				A browserrequest after the end of the program
				returns "Object not found, ......"


				Important:
				At the end of the program we must remove the installed
				cgi function from webservers CGI table.



* Author        : Stoidner
* Date          : 18.12.00
* Version       : V1.00
* ---------------------------------------------------------------------------
* History       :
*
*  Vx.yy        Author  Changes
*
*  V1.00          cs    Create
*  V1.01          cs    revise docu
*
*****************************************************************************/


/****************************************************************************/
//includes
/****************************************************************************/
#include <DOS.H>
#include <STDIO.H>
#include <STRING.H>


/****************************************************************************/
//API includes
/****************************************************************************/


//needed for sleep call
#include "TCPIPAPI.H"
//cgi types, constants, ...
#include "CGI.H"
/*************************************************************************/
//constants
/*************************************************************************/
//needed interrupt vectors
#define TCPIPVECT     0xAC
#define CGIVECT       0xAB


#define MAIN_LOOPS    120L   /* our program run MAIN_LOOPS seconds*/
/****************************************************************************/
//needed registerstructs for CGI interrupt calls
/****************************************************************************/
union  REGS  inregs;
union  REGS  outregs;
struct SREGS segregs;

/***************************************************************************
  the name of the page for the browserrequest
  e.g. http://192.168.200.5/wapcgi
****************************************************************************/
char * WmlPageName     = "wapcgi";
/***************************************************************************
//our cgi entry webserver
 ***************************************************************************/
CGI_Entry   example;

CGI_Entry  * cgiptr;

unsigned long MainLoopCounter = 0L;

/***************************************************************************
Predefine head and tail of our page
***************************************************************************/
char * PageHead = "<?xml version=\"1.0\"?>"
                  "<!DOCTYPE wml PUBLIC \"-//WAP//DTD WML 1.1//EN\" \"http://www.wap.de/DTD/wml_1.1.xml\">"
						"<wml>"
						"<head>"
                  "<meta name=\"keywords\" content=\"wap, chip, ipc, sc12, web\" />"
						"<meta name=\"description\" content=\"IPC@Chip - WAP\" />"
						"<meta name=\"author\" content=\"OK\" />"
						"</head>"
                  "<card id=\"WAP\" title=\"SC12 - WapSite\">"
						    "<p align=\"center\">"
                      "This is the IPC@Chip WAP Example<br/>"
                      "<br/>";


char * PageEnd =      "</p>"
                  "</card>"
                  "</wml>";

/***************************************************************************
we store at the cgi function our page in this buffer
***************************************************************************/

char WmlPage[1024];

/****************************************************************************
	CGI function, the webserver executes this function, if a
	browser request e.g. http://192.168.200.8/wapcgi comes in,
	We build at this function a new wml page in memory,
	which shows the important request fields of the the main
	parameter struct rpCGIPtr



****************************************************************************/

//Microsoft Visual C
#ifdef _MSC_VER
//void far _saveregs _loadds Example1_Func(rpCgiPtr CgiRequest)
void far _pascal _saveregs _loadds Example1_Func(rpCgiPtr CgiRequest)
#else
//void huge  Example1_Func(rpCgiPtr CgiRequest)
void huge _pascal Example1_Func(rpCgiPtr CgiRequest)
#endif

{
   char tmpbuffer[80];

   /**********************************/
   //building the page
   /**********************************/

   //insert the head of the page
   strcpy(WmlPage,PageHead);


	//insert some dynamic code
   sprintf(tmpbuffer,"Meth: %02d<br/>",CgiRequest->fHttpRequest);
   strcat(WmlPage,tmpbuffer);

   sprintf(tmpbuffer,"Url : %s<br/>",CgiRequest->fPathPtr);
   strcat(WmlPage,tmpbuffer);

   sprintf(tmpbuffer,"Host: %s<br/>",CgiRequest->fHostPtr);
   strcat(WmlPage,tmpbuffer);

   //append the predefined tail
   strcat(WmlPage,PageEnd);

   /**********************************/
   //give it to the webserver
   /**********************************/

   CgiRequest->fHttpResponse         = CgiHttpOk;            //HTTP 200 OK
   CgiRequest->fDataType             = CGIDataTypeVndWapWml; // text/vnd.wap.wml

   CgiRequest->fResponseBufferPtr    = WmlPage;
   CgiRequest->fResponseBufferLength = strlen(WmlPage);


}
/****************************************************************************/

int main(void)
{


   printf("\r\nStarting WAP - CGI Example\r\n");

   /*******************************************************************/
   //install example cgi function
   /*****************************************************************/

   //init CGI_entry example;
   example.PathPtr    = WmlPageName;    //name of the page
   example.method     = CgiHttpGet;      //method
   example.CgiFuncPtr = Example1_Func;   //function

   cgiptr =  &example;

   // We need this helpptr because the Microsoft compiler
   // will not accept the following:
   // inregs.x.dx   = FP_SEG(&example);
   // inregs.x.si   = FP_OFF(&example);

   inregs.h.ah   = CGI_INSTALL;
   inregs.x.dx   = FP_SEG(cgiptr);
   inregs.x.si   = FP_OFF(cgiptr);

   int86(CGIVECT,&inregs,&outregs);

   if(outregs.x.dx == (unsigned int)CGI_ERROR)
   {

	  printf("\r\nInstalling CGI function %s failed --> exit program\r\n",example.PathPtr);
	  return 0;
   }

   /******************************************************************
    Now the webserver knows everything about the function and
    is able to execute it, if a browserrequest (handy)
      e.g. http://192.168.200.4/wapcgi
    comes in
   *****************************************************************/




   /*******************************************************************/
   //Main loop: Increment a counter
   //
   /*******************************************************************/
   while(MainLoopCounter < MAIN_LOOPS)
   {

       //increcment the counter for our dynamic html page
       MainLoopCounter++;

       //sleep a second
       inregs.h.ah = API_SLEEP;
       inregs.x.bx = 1000; //milliseconds
       int86(TCPIPVECT,&inregs,&outregs);
   }

   /****************************************/
   //Important: remove example cgi function
   /****************************************/

   inregs.h.ah   = CGI_REMOVE;
   inregs.x.dx   = FP_SEG(example.PathPtr);
   inregs.x.si   = FP_OFF(example.PathPtr);
   int86(CGIVECT,&inregs,&outregs);

   if(outregs.x.dx == (unsigned int)CGI_ERROR)
   {

	  printf("\r\nRemoving %s failed\r\n",example.PathPtr);
	  return 0;
   }


   printf("\r\nExit program\r\n");

   return 0;
}
/*************************************************************************/
//end wapcgi.c
/*************************************************************************/
