/****************************************************************************
*
* (C) 1999 by BECK IPC GmbH
*
*  BECK IPC GmbH
*  Garbenheimerstr. 38
*  D-35578 Wetzlar
*
*  Phone : (49)-6441-905-240
*  Fax   : (49)-6441-905-245
*
* ---------------------------------------------------------------------------
* Module      : cgiapi.c
* Function    : cgi api functions

* Author        : Bartat
* Date          : 27.01.00
* Version       : V1.00
* ---------------------------------------------------------------------------
* History       :
*
*  Vx.yy        Author  Changes
*
*  V1.00          mb    Create
*
*****************************************************************************/

#include <DOS.H>
#include <STDLIB.H>
#include "CGI.H"
/*************************************************************************/

#define CGIVECT       0xAB
/*************************************************************************/
//install cgi function
/*************************************************************************/
int CGI_Install(CGI_Entry far  * cgiptr)
{
   union  REGS  inregs;
   union  REGS  outregs;

   inregs.h.ah   = CGI_INSTALL;
   inregs.x.dx   = FP_SEG(cgiptr);
   inregs.x.si   = FP_OFF(cgiptr);

   int86(CGIVECT,&inregs,&outregs);
   return outregs.x.dx;
}


/*************************************************************************/
//delete cgi function
/*************************************************************************/


int CGI_Delete(char far * PathPtr)
{
   union  REGS  inregs;
   union  REGS  outregs;


   inregs.h.ah   = CGI_REMOVE;
   inregs.x.dx   = FP_SEG(PathPtr);
   inregs.x.si   = FP_OFF(PathPtr);
   int86(CGIVECT,&inregs,&outregs);

   return outregs.x.dx;

}


/*************************************************************************/
//Get formitem
/*************************************************************************/
void CGI_GetFormItem(char far * ArgumentBufferPtr,FormItem far * formitem)
{
	union  REGS  inregs;
	union  REGS  outregs;
	struct SREGS segregs;

	inregs.h.ah = CGI_GETFORMITEM;
	inregs.x.bx = FP_SEG(ArgumentBufferPtr);
	inregs.x.si = FP_OFF(ArgumentBufferPtr);
	segregs.es    = FP_SEG(formitem);
	inregs.x.di = FP_OFF(formitem);
	int86x(CGIVECT,&inregs,&outregs,&segregs);
}

/*************************************************************************/
//Get next formitem
/*************************************************************************/
#pragma argsused
int CGI_GetNextItem(char far * ArgumentBufferPtr, char far * * nextItemString)
{
	union  REGS  inregs;
	union  REGS  outregs;
	struct SREGS segregs;

	inregs.h.ah = CGI_FINDNEXTITEM;
	inregs.x.bx = FP_SEG(ArgumentBufferPtr);
	inregs.x.si = FP_OFF(ArgumentBufferPtr);
	int86x(CGIVECT,&inregs,&outregs,&segregs);

	if(outregs.x.dx==0)
	 *nextItemString = MK_FP(segregs.es, outregs.x.di);
	else
	 *nextItemString = NULL;

	return outregs.x.dx;
}

/*************************************************************************/
//end cgiapi.c