/****************************************************************************
*
* (C) 1999 by BECK IPC GmbH
*
*  BECK IPC GmbH
*  Garbenheimerstr. 38
*  D-35578 Wetzlar
*
*  Phone : (49)-6441-905-240
*  Fax   : (49)-6441-905-245
*
* ---------------------------------------------------------------------------
* Module      : Submit2.c
*
* Function    :
				This program demonstrates the usage of the implemented
				CGI-Interface of IPC@CHIP in a dos program, especially
				the building of formulars and the usage of more than one item.

				The programmer should read and test first the example submit.c
				and use this program as an example	for building own cgi functions.


				Compiler     : Borland C 3.0
				Projectfile  : submit2.prj
				Memorymodel  : Large


* Author        : Bartat
* Date          : 27.01.00
* Version       : V1.00
* ---------------------------------------------------------------------------
* History       :
*
*  Vx.yy        Author  Changes
*
*  V1.00          mb    Create
*  V1.01          mb    Change cgi func declaration to pascal style
*  V1.02          mb    Replaced "" with \" at html strings
*****************************************************************************/

/****************************************************************************/
/* Compiler dependent defines, Microsoft C V152 */
/****************************************************************************/
#ifdef _MSC_VER

  //set structure member assignment to 1Byte !!!!
  #pragma pack(1)

  #ifndef _M_I86LM
	#error Must use LARGE memory model
  #endif

#endif /* _MSC_VER */

/****************************************************************************/
//includes
/****************************************************************************/
#include <DOS.H>
#include <STDIO.H>
#include <STRING.H>
#include <STDLIB.H>
//needed for sleep call
#include "TCPIPAPI.H"
//cgi types, constants, ...
#include "CGI.H"
#include "CGIAPI.H"
#include "RTXAPI.H"
/*************************************************************************/
//constants
/*************************************************************************/
//needed interrupt vectors
#define TCPIPVECT     0xAC


#define MAIN_LOOPS    300L   /* our program run MAIN_LOOPS seconds*/
/***************************************************************************
  the name of the page for the browserrequest
  e.g. http://192.168.200.5/example1
****************************************************************************/
/*static char * HtmlPageName     = "submitexample_2";*/
static char * ProcessName      = "io.cgi";
/***************************************************************************
//our cgi entry webserver
 ***************************************************************************/
static CGI_Entry   submitexample;
static CGI_Entry   processexample;

static unsigned long MainLoopCounter = 0L;

/***************************************************************************/
static char ProcessPageBuffer[2048];
/***************************************************************************/

/******************************/
//static Htmltext for submitexample
/******************************/

static char HtmlSubmitPage[] =

		"<HTML><HEAD><TITLE>VRIJDAG TEST</TITLE></HEAD>"
    "<BODY BGCOLOR=\"#A0A0A0\">"
		"<IMG SRC=\"beck.gif\" ALIGN=\"RIGHT\" ALT=\"BECK\">"
		"<BR><BR>"
		"<CENTER>"
		"<H1>IPC@Chip Form Page</H1>"
		"<HR size=0>"
		"</CENTER>"
    "<P>"
	"<FORM ACTION=/processform_2 METHOD=POST>"
	"Enter something in the boxes "
	"<BR><BR><INPUT TYPE=TEXT NAME=\"Testtext1\" SIZE=15 MAXSIZE=15>"
	"<BR><BR><INPUT TYPE=TEXT NAME=\"Testtext2\" SIZE=15 MAXSIZE=15>"
    "<BR><BR>and <INPUT TYPE=SUBMIT NAME=\"Button\" VALUE=\"Submit\">"
    "</FORM>"
    "<HR size=0>"
		"<p align=center><SMALL><EM>&copy BECK IPC GmbH, 2000</EM>"
		"</BODY>"
		"</HTML>";




/****************************************************/
//static head and tail for processform
/*****************************************************/

static char  HtmlPageHead[] =

		"<HTML><HEAD><TITLE>WEBIO ELEKTUUR write to digital output</TITLE></HEAD>"
		"<BODY BGCOLOR=SILVER TEXT=BLACK>"
		"<CENTER>"
		"<FONT SIZE=+3><B>ELEKTUUR WEBIO</B></FONT>"
		"<P><FONT SIZE=+1><B>write to digital output</B></FONT><BR><HR><BR>"
		"</CENTER>";

static char  HtmlPageTail[] =
		"<HR><BR><FONT SIZE=-1><I>This page is send to you by the WEBIO!</I></FONT>"
		"<BR><A HREF=\"OUTPUT.HTM\">Back to previous page</A><BR>"
		"<A HREF=\"INDEX.HTM\">Back to homepage</A>"
		"</BODY>"
		"</HTML>";


/****************************************************************************
	CGI function, the webserver executes this function, if a
	form was send with the action=io.cgi tag.
****************************************************************************/


//Microsoft Visual C
#ifdef _MSC_VER
void far _saveregs _loadds _pascal Process_Func(rpCgiPtr CgiRequest)
#else
void huge _pascal   Process_Func(rpCgiPtr CgiRequest)
#endif
{

	 char far     * FormNamePtr  = NULL;
	 char far     * FormValuePtr = NULL;

	 char far     * helpnext     = NULL;
	 int result;
	 FormItem far * formitem     = NULL;

/***************************************/
/* These variables hold the values send*/
/* within the form										 */
/***************************************/

	 int						Form_Value;
	 char           Form_Format[]="%d";
	 int				    Form_IO;
	 char 				  Form_Temp[100];
	 int					  Form_Checked = 0;




	 //Insert the head of the dynamic html page
	 strcpy(ProcessPageBuffer,HtmlPageHead);

	 if(strlen(CgiRequest->fArgumentBufferPtr))
	 {
			//alloc memory
		FormNamePtr=(char far *)malloc(sizeof(char )*50);
		FormValuePtr=(char far *)malloc(sizeof(char )*250);
		formitem=(FormItem far *)malloc(sizeof(FormItem));

		if((FormNamePtr!=NULL) && (FormValuePtr!=NULL) && (formitem!=NULL))
		{
			formitem->NamePtr  = FormNamePtr;
			formitem->ValuePtr = FormValuePtr;

			helpnext=CgiRequest->fArgumentBufferPtr;

			do
			{
				CGI_GetFormItem(helpnext, formitem);
				result = CGI_GetNextItem(helpnext, &helpnext);

				if (strcmp(formitem->NamePtr,"Value")==0)
				{
					stpcpy (Form_Temp,formitem->ValuePtr);
				}
				if (strcmp(formitem->NamePtr,"Format")==0)
				{
					if (strcmp(formitem->ValuePtr,"Hex")==0)
					{
						stpcpy(Form_Format,"%x");
					}
				}
				if (strcmp(formitem->NamePtr,"IO")==0)
				{
					sscanf (formitem->ValuePtr,"%d",&Form_IO);
				}
				if (strcmp(formitem->NamePtr,"Confirm")==0)
				{
					Form_Checked=1;
				}
			} while (result == 0);

			sscanf (Form_Temp,Form_Format,&Form_Value);

			if (Form_IO==2)
				outportb (0x101,Form_Value);
			else
				outportb (0x100,Form_Value);

			sprintf (Form_Temp,"<CENTER><B>Send value %d to port %d</B><BR><BR></CENTER>",Form_Value,Form_IO);
			strcat (ProcessPageBuffer,Form_Temp);





			//free memory
			free(FormNamePtr);
			free(FormValuePtr);
			free(formitem);
		}//
		else
		{
			strcat(ProcessPageBuffer,"<P>Webserver, memory allocation failed<P>");
			Form_Checked=1;	/* Make sure we send this error message */
		}
	}//if(strlen(CgiRequest->fArgumentBufferPtr))
	 //Append the tail of the dynamic html page
	strcat(ProcessPageBuffer,HtmlPageTail);


	 //set response fields

	if (Form_Checked)				/* User wants confirmation of command */
	{
		CgiRequest->fHttpResponse         = CgiHttpOk;       //HTTP 200 OK
		CgiRequest->fDataType             = CGIDataTypeHtml; //text/html
		CgiRequest->fResponseBufferPtr    = ProcessPageBuffer; //page address
		CgiRequest->fResponseBufferLength = strlen(ProcessPageBuffer); //length
	}
	else										/* User does not need confirmation	*/
	{
		CgiRequest->fHttpResponse         = CgiHttpOKNoDoc; //No document follows
	}

}


/****************************************************************************/

int main(void)
{

	 int result;
   union  REGS  inregs;
   union  REGS  outregs;

	 printf("\r\nInstalling CGI \"%s\" for IO test \r\n",ProcessName);
   printf("Build : %s %s\n",__DATE__,__TIME__);
   printf("(c) 2001 ELEKTOR\n");

	 /***********************************/
   //install process_form cgi function
   /***********************************/

   //init CGI_entry process;
   processexample.PathPtr     = ProcessName;    //name of the page
   processexample.method      = CgiHttpPost;      //method
   processexample.CgiFuncPtr  = Process_Func;   //function

   result = CGI_Install(&processexample);
   if(result == CGI_ERROR)
   {
	  //should not happen
	  printf("\r\nInstalling CGI function %s failed --> exit program\r\n",submitexample.PathPtr);
	  return 0;
   }


	 /*******************************************************************/
	 //Main loop: Increment a counter
	 //
	 /*******************************************************************/
	 while(MainLoopCounter < MAIN_LOOPS)
	 {

			 //increcment the counter for our dynamic html page
			 MainLoopCounter++;

			 //sleep a second
			 inregs.h.ah = API_SLEEP;
			 inregs.x.bx = 1000; //milliseconds
			 int86(TCPIPVECT,&inregs,&outregs);
	 }




	 /****************************************/
	 /*Important: remove example cgi function*/
	 /*           before returning to OS		 */
	 /*																			 */
	 /****************************************/

	 result = CGI_Delete(processexample.PathPtr);
	 if(result == CGI_ERROR)
	 {

		printf("\r\nRemoving %s failed\r\n",processexample.PathPtr);
		return 0;
	 }
	 printf("\r\n%s removed\r\n",processexample.PathPtr);

	 printf("\r\nExit program\r\n");

	 return 0;
}
/*************************************************************************/
//end submit.c
/*************************************************************************/
