{****************************************************************************
*
* (C) 2000 by BECK IPC GmbH
*
*  BECK IPC GmbH
*  Garbenheimerstr. 38
*  D-35578 Wetzlar
*
*  Phone : (49)-6441-905-240
*  Fax   : (49)-6441-905-245
*
* ---------------------------------------------------------------------------
* Module      : CountCGI.Pas
*
* Function    :
        This program demonstrates the writing of cgi functions
        with Turbo Pascal, by using the CGI API of the
	IPC@CHIP.
	The programmer should use this program as an example
	for programming own cgi functions with Pascal.
        For a better understanding the programmer should first
        read the html documentation of the CGI API.

        Compiler     : Borland Pascal 7.0

        ********************************************************************
        1. What does this program?
        ********************************************************************
        At the start of the programm, we set the current
        root directory of the webserver to the directory
	"web" and set a new mainpage name "index.htm".

	This is only for to demonstrate this features,
	it's not important for the working of the program.

	After doing that, the webserver searches for all
	requested files at this directory.
	A browserrequest with the '/' e.g. http://192.168.205.4/
	is (from now on)  answered from the server with the new
	mainpagefile "index.htm" at the root directory "web".

        Further we install a cgi function, which produces a
	dynamic htmlpage in the memory. This page has the name
	"example2". The name if the installed cgi function
	is "example_func2". The expected http method is "get".

	If a browserrequest e.g. http://192.168.205.4/countcgi
	comes in, the web server calls this function.
	At the mainloop of our program, we increment a counter
	once per second.

	The called function builds a string, which contains
	a small html page with the actual value of our counter.

	During runtime of the program, the page "countcgi"
	can be loaded from a browser.


	After two minutes the program ends.
	A browserrequest after the end of the program
	returns "Object not found, ......"

	Important:
	At the end of the program we must remove the installed
	cgi function from webservers CGI table.





        ********************************************************************
        2. Install a cgi procedure
        ********************************************************************

        The webserver of the IPC@Chip must be informed about
        the new procedure.

        At the main procedure we install our cgi procedure
        First we initialize a variable named example
        of the following record type:

        type CGI_Entry = record
          PathPtr:        ^char;        URL name
          method:         integer;      method
          CGIFuncPtr:     pointer;      pointer to cgi procedure
        end;

        We initialize this variable like the following:


        strcopy(HTMLPageName,'countcgi');
        example.PathPtr    := addr(HtmlPageName);
        example.method     := 1;
        example.CGIFuncPtr := addr( Example2_Proc );


        with the CGI API call CGI_INSTALL_PAS



        regs.ah := 9;
        regs.dx := seg( example );
        regs.si := ofs( example );
        intr( $AB, regs );

        Now the webserver knows the url name and the address of this
        procedure and is able to execute it, if a browserrequest
        e.g http://192.168.200.4/countcgi comes in.


        Important:
	At the end of the program we must remove the installed
	cgi procedure from webservers CGI table.

        ********************************************************************
        3. How to write CGI procedure in Turbo Pascal?
        ********************************************************************

        Programming a CGI procedure with Turbo Pascal is a little
        different from programming them in C.
        A CGI procedure written with Turbo Pascal must be declared with
        no parameters and with the interrupt declaration:

        e.g.  procedure Example2_Proc;interrupt;

        This is necessary because Turbo Pascal did not provide
        a huge(Borland C) or loadds(Micrisoft C) procedure declaration
        for loading the datasegment register at execution time.
        Only the interrupt declaration allow this.


        Before the webserver calls this procedure (after a incoming browserrequest),
        the webserver loads from es:di the address of the CGIRequestPtr.
        CGIRequestPtr is a pointer to the structure rpCGI  (see below or
        read the html documentation of CGI)
        This structure contains all the needed data of http rquest from
        the browser.
        So the first thing you have to do at a CGI procedure is to initialize
        your CGIRequestpointer for having access to this data.

        e.g.
        procedure Example2_Proc;interrupt;
        var

            ESReg       : Integer;
            DIReg       : Integer;
            CGIRequest  :  rpCGIptr;

        begin

              asm
              mov ax,es
              mov EsReg,ax
              mov ax,di
              mov DIReg,ax
              end;

              CGIRequest := ptr(ESReg,DIReg);

              ............
        end;


	The procedure first takes the adress of the CGI RequestPtr
        from ES:DI.
        Then it builds a html pages (by using some string operations)
        which contains the browser request data from the given pointer
	rpCGiPtr
}
{****************************************************************************}
{ some important compiler settings }
{****************************************************************************}
{$G-}
{$D-}
{$R-}
{$F+}
{$A-}
{$S-}
{$M 16384,0,32000}
{*****************************************************************************}

Program CountCGI;

uses dos,strings;

{*************************************************************************}
const MAIN_LOOPS   = 120;

type CGI_Entry = record
       PathPtr:        ^char;         { URL name}
       method:         integer;       { Method}
       CGIFuncPtr:     pointer;       { Pointer to cgi procedure}
     end;


     rpCGIptr = ^rpCGI;    {Pointertyp of the following record}

     rpCGI = record

       {Request fields, read only!!!!}
       fConnectionId:           byte;        {internal use only}
       fHttpRequest:            integer;     {internal use only}
       fPathPtr:                Pchar;       {URL}
       fHostPtr:                Pchar;       {Host}
       fRefererPtr:             Pchar;       {Referer}
       fAgentPtr:               Pchar;       {UserAgent}
       fLanguagePtr:            Pchar;       {Content Language}
       fBrowserDate:            longint;     {Date (internal)}
       fArgumentBufferPtr:      Pchar;       {Pointer at argument buffer}
       fArgumentBufferLength:   longint;     {Length of argument buffer}
       fUserNamePtr:            Pchar;       {Username from Authorization}
       fPasswordPtr:            Pchar;       {Password from Authorization}

       fUserwordPtr:            pointer;     {reserved}

       {* Response fields }

       fResponseState:          integer;     {internal, do not modify}
       fHttpResponse:           integer;     {response msg mostly CgiHttpOK}
       fDataType:               integer;     {content type mostly text/html}
       fResponseBufferPtr:      Pchar;       {pointer to created dynamic html page}
       fResponseBufferLength:   longint;     {length of the created page}
       fObjectDate:             longint;     {internal, do not modify}
       fHostIndex:              word;        {internal, do not modify}
     end;



{*******************}
{* global variables }
var example:            CGI_Entry;
    regs:               registers;
    mainloopcounter:    word;

    HTMLPageName:       array[0..31]   of char;

    PageHead:           array[0..255] of char;   {sizes should be large enough}
    PageEnd:            array[0..255] of char;
    HtmlPage:           array[0..1023] of char;
    MainPageName:       array[0..10] of char;
    WebRootDirectory:   array[0..10] of char;
    MainPageName_ptr:   PChar;
    WebRootDrectory_ptr: PChar;




{*************************************************************************
 This include file contains some needed procedures and function for
 programming pascal programs at the IPC@Chip
 *************************************************************************}
{$I SC12.INC}
{*************************************************************************
A CGI procedure written with Turbo Pascal must be declared with
the interrupt statement.

e.g.  procedure Example2_Proc;interrupt;

Before the webserver calls this procedure after a incoming browserrequest,
the webserver loads from es:di the address of the CGIRequestPtr.
So the first thing you have to do at a CGI procedure is to initialize
your CGIRequestpointer

e.g.
procedure Example2_Proc;interrupt;

var

    ESReg       : Integer;
    DIReg       : Integer;
    CGIRequest  :  rpCGIptr;

begin

      asm
      mov ax,es
      mov EsReg,ax
      mov ax,di
      mov DIReg,ax
      end;

      CGIRequest := ptr(ESReg,DIReg);

      ............
end;

{*************************************************************************}
{* CGI function }
procedure Example2_Proc;interrupt;

var
    tmpstr      : array[0..50] of char;
    ESReg       : Integer;
    DIReg       : Integer;
    CGIRequest  :  rpCGIptr;

begin

     {Very important: Take CGiRequestptr from es:di}
     asm
      mov ax,es
      mov EsReg,ax
      mov ax,di
      mov DIReg,ax
     end;

     CGIRequest := ptr(ESReg,DIReg);


     {*************************************}
     {* insert head of page }
     {*************************************}
     strcopy(HtmlPage, PageHead);


     {* insert main loop counter }
     strcat(HtmlPage, '<BR>Main loop counter ');
     str( MainLoopCounter, tmpstr );
     strcat(HtmlPage, tmpstr );
     strcat(HtmlPage, '<BR>' );

     {********************************}
     {****  insert tail of page  *****}
     {********************************}
     strcat(HtmlPage, PageEnd);



     {***********************************}
     {****  give it to the webserver ****}
     {***********************************}
     CGIRequest^.fhttpResponse         := 0; {* HTTP 200 OK }
     CGIRequest^.fDataType             := 0; {* test/Html }
     CGIRequest^.fresponseBufferPtr    := addr(HtmlPage[0]); {Set buffer pointer}
     CGIRequest^.fResponseBufferLength := strlen(HtmlPage);  {Tell bufferlength}
end;


{*************************************************************************}
{                        main                                             }
{*************************************************************************}
begin


{ Important: Set our own exitproc to the exit procedure }
    Exitproc := @Terminate_Program;



{ Init the htmlname of the page }

   strcopy(HTMLPageName,'countcgi');


{* Predefine head and tail of our page     }
 strcopy(PageHead,
     '<HTML><HEAD><TITLE>IPC@CHIP CGI example2</TITLE></HEAD>'+
     '<BODY BGCOLOR="#A0A0A0">'+
     '<IMG SRC="beck.gif" ALIGN="RIGHT" ALT="BECK">'+
     '<BR><BR>'+
     '<CENTER>'+
     '<H1>IPC@CHIP CGI   Turbo Pascal example2</H1>'+
     '<HR size=0>'+
     '<FONT FACE="Courier" SIZE=+2>' );



 strcopy(PageEnd,
     '</FONT>'+
     '<HR size=0>'+
     '<p align=center><SMALL><EM>&copy BECK IPC GmbH, 2000</EM>'+
     '</BODY>'+
     '</HTML>');





{**********************}
{* start of the program }

     writeln('Starting CGI example2    (Turbo Pascal 7.0)');


     {******************************}
     {**** set new mainpage name ***}
     {******************************}
     regs.ah := 3; { set the CGI interruptfunction: new mainpage name}
     regs.dx := seg(MainPageName);
     regs.si := ofs(MainPageName);
     intr( $AB, regs );

     if (regs.dx <> 0) then { dx<>0  ->  CGI-Error }
       writeln('Setting mainpage ', MainPageName, ' failed --> exit Program');



     {************************************************}
     {**** set new rootdirectory for the webserver ***}
     {************************************************}
     regs.ah := 4; { set the CGI interruptfunction: set new root dir}
     regs.dx := seg(WebRootDirectory);
     regs.si := ofs(WebRootDirectory);
     intr( $AB, regs );

     if (regs.dx <> 0) then { dx<>0  ->  CGI-Error }
       writeln('Setting root directory ', WebRootDirectory, ' failed --> exit Program');



     {******************************}
     {* install example cgi funtion }
     {******************************}


     {Set URLName}
     example.PathPtr    := addr(HtmlPageName);
     {Set method = GET}
     example.method     := 1;
     {Set Procedure address}
     example.CGIFuncPtr := addr( Example2_Proc );

     regs.ah := 9; { set the CGI install function CGI_INSTALL_PAS }
     regs.dx := seg( example );
     regs.si := ofs( example );
     intr( $AB, regs );

     if (regs.dx <> 0) then { dx<>0  ->  CGI-Error }
     begin
       writeln('Installing CGI function ', HtmlPageName, ' failed --> exit Program');
       halt(1);
     end;


     {******************************************************************
      Now the webserver knows everything about the function and
      is able to execute it, if a browserrequest
      e.g. http://192.168.200.4/example2
      comes in
      *****************************************************************}



     {************************************************************}
     {* main loop: increment a counter                            }
     {************************************************************}
     while mainloopcounter < MAIN_LOOPS do
     begin

          {* increment the counter for our dynamic html page }
          inc( mainloopcounter);

          {* sleep a second }
          regs.ah := 9;    {* set the function API sleep }
          regs.bx := 1000; {* sleep for 1000 miliiseconds }
          intr( $AC, regs );
     end;



     {******************************************}
     {* important: remove example CGI function  }
     {******************************************}
     regs.ah := 2; {* set the CGI remove function }
     regs.dx := seg( HtmlPageName );
     regs.si := ofs( HtmlPageName );
     intr( $AB, regs );

     if (regs.dx <> 0) then { dx<>0  ->  CGI-Error }
     begin
      writeln('Removing ', HtmlPageName, ' failed');
      halt(1);
     end;

     writeln('Exit program');

     {* exit procedure }
     terminate_program;
end.