{****************************************************************************
*
* (C) 2000 by BECK IPC GmbH
*
*  BECK IPC GmbH
*  Garbenheimerstr. 38
*  D-35578 Wetzlar
*
*  Phone : (49)-6441-905-240
*  Fax   : (49)-6441-905-245
*
* ---------------------------------------------------------------------------
* Module      :   SC12.INC
*
* Function    :   some needed and useful functions for programming
*                 pascal programs for the IPC@Chip
*		  Compiler     : Borland Pascal 7.0
*
*
*
* Author        : Bartat
* Date          : 24.02.2000
* Version       : V1.00
* ---------------------------------------------------------------------------
* History       :
*
*  Vx.yy         Author  Changes
*
*  V1.00          mb    Create and test
*       27.06.00  mb      fixed bug at exit proc terminate_program (vect 0x3e)

*****************************************************************************}


{*****************************************************************************
*
* (C) 1999 by Beck IPC GmbH
*
* ---------------------------------------------------------------------------
* Function      : check if key was pressed
* Public/Local  : public
* Parameters    : -/-
* Return        : Boolean : True = key was pressed (is in buffer)
*                           False = no key was pressed
* ---------------------------------------------------------------------------
* Author        : ch
* Last Changes  : 05.08.99
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00   05.08.99   ch    first version
****************************************************************************}

Function Keypressed:boolean;
Var Regs : registers;
Begin
   Regs.ah:=1;
   Intr($16,Regs);
   KeyPressed:=regs.flags and fzero = 0;
End;

{*****************************************************************************
*
* (C) 1999 by Beck IPC GmbH
*
* ---------------------------------------------------------------------------
* Function      : wait until key is pressed and returns key as char
* Public/Local  : public
* Parameters    : -/-
* Return        : Char : pressed key
* ---------------------------------------------------------------------------
* Author        : ch
* Last Changes  : 05.08.99
* Version       : 1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00   05.08.99   ch    first version
****************************************************************************}
Function ReadKey:Char;
Var Regs:registers;
Begin
   Regs.ah:=0;
   Intr($16,Regs);
   Readkey:=Chr(regs.al);
End;



{*****************************************************************************
*
* (C) 2000 by Beck IPC GmbH
*
* ---------------------------------------------------------------------------
* Function      : Set the Stdio focus of the IPC@chip
* Public/Local  : public
* Parameters    : focus:    1: command 2: application 3: both
* Return        : -/-
* ---------------------------------------------------------------------------
* Author        :  mb
* Last Changes  :  24.02.00
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00   24.02.00   mb    create
****************************************************************************}
Procedure Set_Stdio_Focus(focus: word);
var regs: registers;
begin
  if (focus > 0) AND ( focus < 3) then
  begin
    regs.ah := $11;
    regs.al := focus;
    intr( $A0, regs );
  end
end;

{*****************************************************************************
*
* (C) 1999 by Beck IPC GmbH
*
* ---------------------------------------------------------------------------
* Function      : Terminate_program  program exit procedure
*                 This procedure is called at the end of a pascal program,
*                 running at the IPC@Chip
*                 instead of the standard borland pascal exit procedure
*                 Important:
*                 At the start of the program, the system pointer Exitproc
*                 must be set to this procedure:
*
*                 Exitproc := @Terminate_Program;
*
* Public/Local  : public
* Parameters    : -/-
* Return        : -/-
* ---------------------------------------------------------------------------
* Author        :  ch
* Last Changes  :  20.07.99
* Version       :  1.00
* ---------------------------------------------------------------------------
* History:
*
*  Vx.yy  Date     Author  Changes
*  1.00   20.07.99   ch    first version
****************************************************************************}
procedure Terminate_program;
var
   regs : REGISTERS;

begin

   { restore interrupt vectors, which were modified by startup code }

   asm
      cli
   end;

   SetIntVec($00,SaveInt00);
   SetIntVec($02,SaveInt02);
   SetIntVec($23,SaveInt23);
   SetIntVec($24,SaveInt24);
   SetIntVec($34,SaveInt34);
   SetIntVec($35,SaveInt35);
   SetIntVec($36,SaveInt36);
   SetIntVec($37,SaveInt37);
   SetIntVec($38,SaveInt38);
   SetIntVec($39,SaveInt39);
   SetIntVec($3a,SaveInt3a);
   SetIntVec($3b,SaveInt3b);
   SetIntVec($3c,SaveInt3c);
   SetIntVec($3d,SaveInt3d);
   SetIntVec($3e,SaveInt3e);
   SetIntVec($75,SaveInt75);

   asm
      sti
   end;

   regs.ah := $04C ; { Terminate program }
   Intr($21,regs);   { Call DOS }
end;


{*****************************************************************************}
                        { end SC12.INC  }
{*****************************************************************************}

