{**************************7**************************************************
*
* (C) 2000 by BECK IPC GmbH
*
*  BECK IPC GmbH
*  Garbenheimerstr. 38
*  D-35578 Wetzlar
*
*  Phone : (49)-6441-905-240
*  Fax   : (49)-6441-905-245
*
* ---------------------------------------------------------------------------
* Module      : DK40_set.Pas
*
* Function    :
        This program demonstrates the writing of cgi functions
        with Turbo Pascal, by using the CGI API of the
	IPC@CHIP.
	The programmer should use this program as an example
	for programming own cgi functions with Pascal.
        For a better understanding the programmer should first
        read the html documentation of the CGI API.

        Compiler     : Borland Pascal 7.0

        ********************************************************************
        1. What does this program?
        ********************************************************************
        This program generate a CGI-script which returns a simple
        HTMLPage with 14 links, which allows per click to set or
        reset the DK40 IO pins 0-6

        The page has the name "dk40_set". The name of the installed
        cgi function is "DK40_Func". The expected http method is "get".

	If a browserrequest e.g. http://192.168.205.4/dk40_set
	comes in, the web server calls this function.

	The called function check for committed paramters. At the first
        start of the function, no parameters are comitted. The function
        returns a HTMLPage. If you chose one of the 14 links in your web
        browser, the page starts the cgi-functions again, but with comitted
        parameters. The parameter is the value for the DK40 IO pins. The
        cgi-functions set the IO Pins and go back to the webserver.

        The mainloop is always true, and there for neverending.


        ********************************************************************
        2. Install a cgi procedure
        ********************************************************************

        The webserver of the IPC@Chip must be informed about
        the new procedure.

        At the main procedure we install our cgi procedure
        First we initialize a variable named example
        of the following record type:

        type CGI_Entry = record
          PathPtr:        ^char;        URL name
          method:         integer;      method
          CGIFuncPtr:     pointer;      pointer to cgi procedure
        end;

        We initialize this variable like the following:


        strcopy(HTMLPageName,'dk40_set');
        example.PathPtr    := addr(HtmlPageName);
        example.method     := 1;
        example.CGIFuncPtr := addr( DK40_Func );


        with the CGI API call CGI_INSTALL_PAS

        regs.ah := 9;
        regs.dx := seg( example );
        regs.si := ofs( example );
        intr( $AB, regs );

        Now the webserver knows the url name and the address of this
        procedure and is able to execute it, if a browserrequest
        e.g http://192.168.200.4/dk40_set comes in.


        ********************************************************************
        3. How to write CGI procedure in Turbo Pascal?
        ********************************************************************

        Programming a CGI procedure with Turbo Pascal is a little
        different from programming them in C.
        A CGI procedure written with Turbo Pascal must be declared with
        no parameters and with the interrupt declaration:

        e.g.  procedure DK40_Func;interrupt;

        This is necessary because Turbo Pascal did not provide
        a huge(Borland C) or loadds(Micrisoft C) procedure declaration
        for loading the datasegment register at execution time.
        Only the interrupt declaration allow this.


        Before the webserver calls this procedure (after a incoming browserrequest),
        the webserver loads from es:di the address of the CGIRequestPtr.
        CGIRequestPtr is a pointer to the structure rpCGI  (see below or
        read the html documentation of CGI)
        This structure contains all the needed data of http rquest from
        the browser.
        So the first thing you have to do at a CGI procedure is to initialize
        your CGIRequestpointer for having access to this data.

        e.g.
        procedure DK40_Func;interrupt;
        var

            ESReg       : Integer;
            DIReg       : Integer;
            CGIRequest  :  rpCGIptr;

        begin

              asm
              mov ax,es
              mov EsReg,ax
              mov ax,di
              mov DIReg,ax
              end;

              CGIRequest := ptr(ESReg,DIReg);

              ............
        end;


	The procedure first takes the adress of the CGI RequestPtr
        from ES:DI.
        Then it builds a html pages (by using some string operations)
        which contains the browser request data from the given pointer
	rpCGiPtr
}
{****************************************************************************}
{ some important compiler settings }
{****************************************************************************}
{$G-}
{$D-}
{$R-}
{$F+}
{$A-}
{$S-}
{$M 16384,0,32000}
{*****************************************************************************}

Program dk40_set;

uses dos,strings;

{*************************************************************************}
const MAIN_LOOPS   = 120;
type CGI_Entry = record
       PathPtr:        ^char;         { URL name}
       method:         integer;       { Method}
       CGIFuncPtr:     pointer;       { Pointer to cgi procedure}
     end;


     rpCGIptr = ^rpCGI;    {Pointertyp of the following record}

     rpCGI = record

       {Request fields, read only!!!!}
       fConnectionId:           byte;        {internal use only}
       fHttpRequest:            integer;     {internal use only}
       fPathPtr:                Pchar;       {URL}
       fHostPtr:                Pchar;       {Host}
       fRefererPtr:             Pchar;       {Referer}
       fAgentPtr:               Pchar;       {UserAgent}
       fLanguagePtr:            Pchar;       {Content Language}
       fBrowserDate:            longint;     {Date (internal)}
       fArgumentBufferPtr:      Pchar;       {Pointer at argument buffer}
       fArgumentBufferLength:   longint;     {Length of argument buffer}
       fUserNamePtr:            Pchar;       {Username from Authorization}
       fPasswordPtr:            Pchar;       {Password from Authorization}

       fUserwordPtr:            pointer;     {reserved}

       {* Response fields }

       fResponseState:          integer;     {internal, do not modify}
       fHttpResponse:           integer;     {response msg mostly CgiHttpOK}
       fDataType:               integer;     {content type mostly text/html}
       fResponseBufferPtr:      Pchar;       {pointer to created dynamic html page}
       fResponseBufferLength:   longint;     {length of the created page}
       fObjectDate:             longint;     {internal, do not modify}
       fHostIndex:              word;        {internal, do not modify}
     end;



{*******************}
{* global variables }
var example:            CGI_Entry;
    regs:               registers;
    old_outval:        byte;

    HTMLPageName:       array[0..31]   of char;

    PageHead:           array[0..255] of char;   {sizes should be large enough}
    PageBody:           array[0..255] of char;
    PageEnd:            array[0..255] of char;
    HtmlPage:           array[0..1023] of char;
    MainPageName:       array[0..10] of char;
    WebRootDirectory:   array[0..10] of char;


{*************************************************************************
 This include file contains some needed procedures and function for
 programming pascal programs at the IPC@Chip
 *************************************************************************}
{$I SC12.INC}
{*************************************************************************
A CGI procedure written with Turbo Pascal must be declared with
the interrupt statement.

e.g.  procedure DK40_Func;interrupt;

Before the webserver calls this procedure after a incoming browserrequest,
the webserver loads from es:di the address of the CGIRequestPtr.
So the first thing you have to do at a CGI procedure is to initialize
your CGIRequestpointer

e.g.
procedure DK40_Func;interrupt;

var

    ESReg       : Integer;
    DIReg       : Integer;
    CGIRequest  :  rpCGIptr;

begin

      asm
      mov ax,es
      mov EsReg,ax
      mov ax,di
      mov DIReg,ax
      end;

      CGIRequest := ptr(ESReg,DIReg);

      ............
end;

{*************************************************************************}
{* CGI function }
procedure DK40_Func;interrupt;

var
    tmpstr      : array[0..50] of char;
    tmp         : Integer;
    bit         : Integer;
    code        : Integer;
    ESReg       : Integer;
    DIReg       : Integer;
    CGIRequest  :  rpCGIptr;

begin

     {Very important: Take CGiRequestptr from es:di}
     asm
      mov ax,es
      mov EsReg,ax
      mov ax,di
      mov DIReg,ax
     end;

     CGIRequest := ptr(ESReg,DIReg);


     {*************************************}
     {* check if there are arguments       }
     {*************************************}
     if (CGIRequest^.fArgumentBufferLength = 0) then
     begin
      {* we send the page to the webserver}
      CGIRequest^.fHttpResponse         := 0; {* HTTP 200 OK }
      CGIRequest^.fDataType             := 0; {* test/Html }
      CGIRequest^.FresponseBufferPtr    := addr( HtmlPage ) ; {Set buffer pointer}
      CGIRequest^.fResponseBufferLength := strlen(HtmlPage);{Tell buffer length}
      exit;
     end;


     {**********************}
     {* parse the arguments }
     {**********************}
     if (CGIRequest^.fArgumentBufferLength = 2) then
     begin
          val(CGIRequest^.fArgumentBufferPtr[0], bit, code);
          if ( code<>0 ) then exit;
          if ( (bit>=0) and (bit<7) ) then
          begin
           {* read the current value }
           old_outval := port[$600];

           val(CGIRequest^.fArgumentBufferPtr[1], tmp, code);
           if ( code<>0 ) then exit;
           case (tmp) of

                0: begin
                        old_outval := old_outval and ( not ( 1 shl bit )  );
                        port[$600] := old_outval;
                   end;

                1: begin
                        old_outval := old_outval or  ( 1 shl bit );
                        port[$600] := old_outval;
                   end;

                else exit;

           end; {* case}

          end; {* if ( (bit...}

     end; {* if (CGIRequest...}


     {***********************************}
     {****  give it to the webserver ****}
     {***********************************}
     CGIRequest^.fhttpResponse         := 6; {* HTTP 204 OK as Http reponse }
                                             {*  because we are sending no  }
                                             {*  document                   }
     CGIRequest^.fresponseBufferPtr    := NIL;
     CGIRequest^.fResponseBufferLength := 0;
end;

{*************************************************************************}
{                        main                                             }
{*************************************************************************}
begin
{ Important: Set our own exitproc to the exit procedure }
   Exitproc := @Terminate_Program;

{*************************************************************************
The functions "strcopy" and "strcat" in can only copy 255 characters.
To copy more than that, you have to split your string in max. 255 character
packages.

e.g.     strcopy( HTMLPage,
            '<HTML><HEAD> .... </HEAD> ....' );   (The first package)

         strcat( HTMLPage,
            '<BODY> This is my SC12 - Page ...'); (The second package)

         strcat( HTMLPage,
            '.. The topic of the page ...');      (The third package)

         strcat( HTMLPage,
            'And this is the end...');            (The last package)
*************************************************************************}
{* generate HTMLPage }

   {1st package}
   strcopy(HTMLPage,
     '<HTML><HEAD><TITLE>IPC@CHIP CGI DK40</TITLE></HEAD>'+
     '<BODY BGCOLOR="#A0A0A0">'+
     '<BR>'+
     '<CENTER>'+
     '<H1>IPC@CHIP CGI DK40</H1>'+
     '<HR size=0>'+
     '<FONT FACE = "Courier" SIZE=+1' );

   {2nd package}
   strcat(HTMLPage,
     '<P>Pin 0:  <A HREF="dk40_set?01">Set</A>         '+
     '   <A HREF="dk40_set?00">Reset</A></P>'+
     '<P>Pin 1:  <A HREF="dk40_set?11">Set</A>         '+
     '   <A HREF="dk40_set?10">Reset</A></P>');

   {3rd package}
   strcat(HTMLPage,
     '<P>Pin 2:  <A HREF="dk40_set?21">Set</A>         '+
     '   <A HREF="dk40_set?20">Reset</A></P>'+
     '<P>Pin 3:  <A HREF="dk40_set?31">Set</A>         '+
     '   <A HREF="dk40_set?30">Reset</A></P>');

   {4th package}
   strcat(HTMLPage,
     '<P>Pin 4:  <A HREF="dk40_set?41">Set</A>         '+
     '   <A HREF="dk40_set?40">Reset</A></P>'+
     '<P>Pin 5:  <A HREF="dk40_set?51">Set</A>         '+
     '   <A HREF="dk40_set?50">Reset</A></P>');

   {5th package}
   strcat(HTMLPage,
     '<P>Pin 6:  <A HREF="dk40_set?61">Set</A>         '+
     '   <A HREF="dk40_set?60">Reset</A></P>');

   {6th package}
   strcat(HTMLPage,
     '</Font>'+
     '<HR SIZE=0>'+
     '<P ALIGN=CENTER><SMALL><EM>&copy BECK IPC GmbH, 1999</EM>'+
     '</CENTER>'+
     '</BODY>'+
     '</HTML>');


{* Init the htmlname of the page }
   strcopy(HTMLPageName,'dk40_set');



{****************************************************************************
    CGI function, the webserver executes this function, if a
    browser request e.g. http://192.168.200.8/dk40_set comes in,

    If the browserrequest is send without any arguments, we send
    the predefined page in memory (htmlpage).

    If there are valid arguments, we parse them, and set or reset the
    requested output of the dk40 and return no page.

    The  arguments are made simple:
                  00 means reset DK40 Output 0
                  01       set   DK40 Output  0
                  ...
                  61 means set   DK40 Output 6
****************************************************************************}




{**********************}
{* start of the program }


     writeln('Starting DK40 CGI Example    (Turbo Pascal 7.0)');


     {Init chip selects for usage of port 600, see HW API}
     regs.ah := $83;
     regs.dx := $40;
     intr( $A2, regs );


     {* set all DK40 ouports to zero}
     port[$600] := $00;

     {******************************}
     {* install example cgi funtion }
     {******************************}
     {Set URLName}
     example.PathPtr    := addr(HtmlPageName);
     {Set method = GET}
     example.method     := 1;
     {Set Procedure address}
     example.CGIFuncPtr := addr( DK40_Func );

     regs.ah := 9; { set the CGI install function CGI_INSTALL_PAS }
     regs.dx := seg( example );
     regs.si := ofs( example );
     intr( $AB, regs );

     if (regs.dx <> 0) then { dx<>0  ->  CGI-Error }
     begin
       writeln('Installing CGI function ', HtmlPageName, ' failed --> exit Program');
       halt(1);
     end;


     {******************************************************************
      Now the webserver knows everything about the function and
      is able to execute it, if a browserrequest
      e.g. http://192.168.200.4/DK40_set
      comes in
      *****************************************************************}



     {************************************************************}
     {* main loop: Do nothing at all                              }
     {************************************************************}
     while (TRUE) do
     begin
         {* sleep a second }
          regs.ah := 9;    {* set the function API sleep }
          regs.bx := 1000; {* sleep for 1000 miliiseconds }
          intr( $AC, regs );
     end;

     {* we dont need to remove the CGI-function, because *}
     {* the program is neverending                       *}

       {* exit procedure }
     terminate_program;

end.