/****************************************************************************
*
* (C) 1999 by BECK IPC GmbH
*
*  BECK IPC GmbH
*  Garbenheimerstr. 38
*  D-35578 Wetzlar
*
*  Phone : (49)-6441-905-240
*  Fax   : (49)-6441-905-245
*
* ---------------------------------------------------------------------------
* Module        : RTXAPI.H
* Function      : Constants, protoypes for RTX, use model large at your program,
*                 if you use this include file.
*                 See html documentation of the RTOS API for details.
* Author        : Schloesser/Bartat
* Date          : 05.11.99
* Version       : V1.00
* ---------------------------------------------------------------------------
* History       :
*
*  Vx.yy                 Author  Changes
*
*  V1.00      05.11.99   es    Create
*             17.01.00   mb    add more RTOS calls (see html-documentation)
*             22.07.00   mb    add timer procedure calls,
*                               change API call defines from dec to hex
*             20.08.00   mb    add task state API calls
*             24.08.00   mb    add API calls suspend and resume tasks
*             23.10.00   mb    add event group calls
*             26.10.00   mb    add message exchange calls
******************************************************************************/
#ifndef RTX_API_H_
#define RTX_API_H_
/*****************************************************************************/
//function numbers
/*****************************************************************************/
//Taskcontrol
#define RTX_SLEEP_TIME        0x00   /* Sleep for a defined time */
#define RTX_TASK_CREATE       0x01   /* Create and start a task  */
#define RTX_TASK_KILL         0x02   /* Stop and kill a task*/
#define RTX_TASK_DELETE       0x03   /* Remove a task from the system */
#define RTX_GET_TASKID        0x04   /* Get ID of the current running task*/
#define RTX_SLEEP_REQ         0x05   /* Sleep, until a wake request occurs*/
#define RTX_WAKEUP_TASK       0x06   /* Wake a task, which is waiting*/
#define RTX_END_EXEC          0x07   /* End task execution*/
#define RTX_CHANGE_PRIO       0x08   /* Change the priority of a task*/
#define RTX_ACCESS_FILESYSTEM 0x09    /* Enable filesystem access for task*/
#define RTX_GET_TASK_STATE      0x0A    /* Get the state of a task*/
#define RTX_GET_TASK_LIST       0x0B    /* Get tasklist*/
#define RTX_START_TASK_MONITOR  0x0C    /* Start task monitoring*/
#define RTX_STOP_TASK_MONITOR   0x0D    /* Stop task monitoring*/
#define RTX_SUSPEND_TASK        0x0E    /* Suspend a task */
#define RTX_RESUME_TASK         0x0F    /* Resume a task */
#define RTX_RESTART_TASK         0x10    /* Restart a killed task */



//Semaphores
#define RTX_CREATE_SEM    0x14   /* Create a semaphore */
#define RTX_DELETE_SEM    0x15   /* Delete a semaphore */
#define RTX_FREE_RES      0x16   /* Free a resource semaphore  */
#define RTX_GET_SEM       0x17   /* Get use of a counting semaphore(no wait)*/
#define RTX_RELEASE_SEM   0x18   /* Release a resource semaphore*/
#define RTX_RESERVE_RES   0x19   /* Reserve a resource semaphore*/
#define RTX_SIGNAL_SEM    0x1A   /* Signal a counting semaphore */
#define RTX_WAIT_SEM      0x1B   /* Wait on a counting semaphore (optional timeout)*/


//Time/Date control
#define RTX_GET_TIMEDATE  0x28
#define RTX_SET_TIMEDATE  0x29
#define RTX_GET_TICKS     0x2A


/* Timer procedures */
#define RTX_INSTALL_TIMER 0x30     /*Install a timer procedure*/
#define RTX_REMOVE_TIMER  0x31    /*Remove a timer procedure from the system*/
#define RTX_START_TIMER   0x32    /*Start periodic execution of a installed timer procedure*/
#define RTX_STOP_TIMER    0x33    /*Stop periodic execution of a timer procedure*/



//Event manager
#define  RTX_CREATE_EVENTGROUP    0x40 /*Create an event group*/
#define  RTX_DELETE_EVENTGROUP    0x41 /*Delete an event group*/
#define  RTX_SIGNAL_EVENTS        0x42 /* Signal one or more events in a group*/
#define  RTX_WAIT_EVENTS          0x43 /*Wait for all/any of a set of events in a group*/
#define  RTX_GET_EVENTGROUP_STATE 0x44 /*Read current state of events in a group*/
#define  RTX_GET_EVENT_FLAGS      0x45 /*Get saved event flags*/
#define  RTX_FIND_EVENTGROUP      0x46 /*ind the eventgroup id of an event group with a specific tag*/




//Message exchange manager
#define RTX_CREATE_MSG    0x50  /*Create a messsage exchange*/
#define RTX_DELETE_MSG    0x51  /*Delete a message exchange*/
#define RTX_SEND_MSG      0x52  /*Send a message to a message exchange*/
#define RTX_GET_MSG       0x53  /*Get a message ,if any (no wait)*/
#define RTX_WAIT_MSG      0x54  /*Wait for message to arrive (optional timeout)*/
#define RTX_FIND_MSG      0x55  /*Find exchange ID of a message exchange by name tag*/


/**************************************************************************************************/
//returned common API errorcodes at dx register, special RTOS errorcodes are listed at the HTML-Docs
/************************************++++**********************************************************/
#define RTX_ENOERROR		    0
#define RTX_ERROR          -1
#define RTX_NOT_SUPPORTED  -2


/*****************************************************************************/
//typedefs
/*****************************************************************************/
/* ID type for tasks ,semaphores */

typedef unsigned int RTOS_ID ;



/*Task Definition Structure */
typedef struct tag_taskdefblock
{
	void	(*proc)();		          /* task procedure pointer	*/
	char	name[4];		             /* name 4 characters not null terminated */
	unsigned int * stackptr;		 /* task stack pointer		*/
	unsigned int stacksize;		    /* size of task stack (bytes)	*/
	unsigned short int attrib;	    /* task attributes, not supported by the RTOS API	*/
	short int priority;		       /* task priority,	range: 20<=priority<=127*/
	unsigned short int time_slice; /* 0: none, !=0: number of milliseconds before task force to relinquish processor*/
	short int mailboxlevel1;		 /* depth of mailbox i: 0 not used, else 1 - 8 mailboxdepth*/
	short int mailboxlevel2;       /* max. number of messages resides inside a task mailbox*/
	short int mailboxlevel3;
	short int mailboxlevel4;
}TaskDefBlock;



typedef struct tagtasklist
{
     unsigned int taskID;         /*task identifier*/
     char taskname[5];            /* unique name 4 characters , 0 terminated */
}TaskList;



typedef struct tag_task_statedata{
                               unsigned int taskID;
                               unsigned int taskPrio;
                               unsigned int taskState;   /*taskstate see below*/
                               unsigned int taskCount;   /*count of the taskmonitor, if taskmon is active*/
                               unsigned int stackused;   /*used stack in percent*/
                               unsigned int stacksize;   /*whole stacksize*/
}Task_StateData;

/*taskstates (16Bit value)
Bit0 timer wait (used with other bits)
Bit1 trigger wait (i.e. idle)
Bit2 semaphore wait
Bit3 event group wait
Bit4 message exchange wait
Bit5 message send wait
Bit6 suspended (waiting for resume)
Bit7 waiting for wake
>Bit7 internal use only
*/


/*Time/Date Structure*/
typedef struct tag_time
{
	unsigned char sec;	/* seconds	(0-59)	*/
	unsigned char min;	/* minutes	(0-59)	*/
	unsigned char hr;	   /* hours	(0-23)		*/
	unsigned char dy;	   /* day		(1-31)	*/
	unsigned char mn;	   /* month	(1-12)		*/
	unsigned char yr;	   /* year		(0-99)	*/
	unsigned char dow;	/* day of week	(Mon=1 to Sun=7)	   */
	unsigned char dcen;  /* century if time/date is correct	*/
}TimeDate_Structure;

/*Timer procedure structure*/
typedef struct tag_timer_proc
{
   unsigned int    *  timerID;     /*pointer to storage the unique timerID*/
   void	(*proc)();       /*pointer to the procedure to be executed*/
   void  *dummyptr;       /*dummypointer, not used at the moment */
   char  name[4];         /*pointer to a unique 4 character name*/
   long       interval;   /*timer execution interval*/
}TimerProc_Structure;


/*Event manager: Wait for event structure*/
typedef struct tag_rtx_event_wait
{
  unsigned int mask;   //16-Bit mask identifying the flags of interest of the group.
  unsigned int value;  //16 Bit value, which specfies the states of interest for each flag selcted by the mask.
  int match;           //event match requirements, 0:only one flag must match with value, !=0: all by mask specified flags must match
  long timeout;        //Maximum time (milliseconds) for waiting for an event match
}RTX_Wait_Event;


/*Message exchange create structure*/
typedef struct tag_rtx_msg{
  unsigned int  msgID;    //for storage the unique message exchange ID
  char name[4]; // name 4 characters, not null terminated
  int  mb0;     //numbers of message envelopes, which can reside in each of the exchange mailbox, max. 8
  int  mb1;
  int  mb2;
  int  mb3;
}RTX_Msg;


/*Message exchange wait structure*/
typedef struct tag_rtx_wait_msg{
  unsigned int   msgID;      //ID of the message exchange
  int   prio;      // priority for wait (0-3),  0=highest
  char *msg;        //pointer ot userbuffer to storage the arrived message
  long timeout;    //Maximum time (milliseconds) for waiting for a message
}RTX_Wait_Msg;




/*****************************************************************************/
#endif  /*RTX_API_H_*/
/*****************************************************************************/
//rtxapi.h
