/****************************************************************************
*
* (C) 2000 by BECK IPC GmbH
*
*  BECK IPC GmbH
*  Garbenheimerstr. 38
*  D-35578 Wetzlar
*
*  Phone : (49)-6441-905-240
*  Fax   : (49)-6441-905-245
*
* ---------------------------------------------------------------------------
* Module         : tcpip.h
*
* Function       : prototypes, constants for TCPIP API functions
*                  Functions must be used with program memory model large!
*
* Author        : bartat
* Date          : 22.01.00
* Version       : V1.00
* ---------------------------------------------------------------------------
* History       :
*
*  Vx.yy                   Author  Changes
*
*  V1.00      22.01.00       mb    Create
*             28.01.00      mb     add tcp API calls
*             26.06.00      mb     add ppp server API calls
*             14.07.00      mb     add reconfig, dhcp  and ip setting API calls
*             18.07.00      mb     add TCPIP statistics
*             24.08.00      mb     add PPP client API calls
*             06.09.00      mb     add set and getsockopt calls
              15.09.00      mb     add ping api calls
              07.11.00      mb     add memory information call
              08.12.00      mb     add routing calls
              22.12.00      mb     add blocking mode call for sockets
*****************************************************************************/
#ifndef __TCPIP_H__
#define __TCPIP_H__
/*************************************************************************/
#include "TCPIPAPI.H"

/*************************************************************************/
#define TCPIPVECT  0xAC

#ifdef _MSC_VER /* If Microsoft C Compiler is used, define new FP_SEG and FP_OFF Macro */
	#ifdef FP_SEG
  		#undef FP_SEG
	#endif
	#define FP_SEG(ptr)    ((unsigned int)(((unsigned long)ptr)>>16))

	#ifdef FP_OFF
  		#undef FP_OFF
	#endif
	#define FP_OFF(ptr)    ((unsigned int)(((unsigned long)ptr)&0xFFFF))
#endif

/*************************************************************************/
//prototypes
/*************************************************************************/

int accept(int sd, struct sockaddr * addressPtr, int *error);

void api_sleep(unsigned int howlong);

int bind(int sd, struct sockaddr * addressPtr, int *error);

int connect(int sd, struct sockaddr * addressPtr, int *error);

int closesocket(int sd, int *error);

int GetWaitingBytes(int sd, int *error);

unsigned int htons(unsigned int value);

int listen(int sd,int backlog, int *error);

int inet_addr(char * IPAddressStringPtr, unsigned long * IPAddress);

int InetToAscii(unsigned long * IPAddress, char * IPAddressStringPtr);

int recvfrom(int sd, char * bufptr, int bufLen, int flags,
				 unsigned long timeout,struct sockaddr * fromPtr, int *error);

int recv(int sd, char * bufptr, int bufLen, int flags, unsigned long timeout,
			int *error);

int ResetConnection(int sd, int *error);

int sendto(int sd, char * bufptr, int bufLen, int flags,
			  const struct sockaddr * toPtr, int *error);

int send(int sd, char * bufptr, int bufLen, int flags, int *error);

int setlinger(int sd, int seconds, int *error);

int setreuse(int sd,int *error);

int Set_IP_Type_Of_Service(int sd, unsigned char TOS, int *error);

int opensocket(unsigned char type, int *error);

int setsockopt(int sd, SetSocketOption *sockoptptr, int *error);

int getsockopt(int sd, GetSocketOption *sockoptptr, int *error);

int Set_Blocking_Mode(int sd, unsigned char mode, int *error);

//ppp client prototypes
int PPP_Client_Open(PPPClient_Init * ptr, int *error);
int PPP_Client_Close(int *error);
int PPP_Client_GetStatus(int *error);



//ppp server prototypes
int PPP_Server_Installed(void);
int PPP_Server_Suspend(int timeoutsecs, int *error);
int PPP_Server_Activate(int timeoutsecs,int *error);
int PPP_Server_GetStatus(void);
int PPP_Server_Get_Cfg(PPP_IPCfg_Data *ptr , int *error);


//system
void Get_Installed_Servers(unsigned int * AX, unsigned int *DX);
int  Reconfigure_ethernet(void);
int  DHCP_use(unsigned char dhcp_use);
void Get_DHCP_Status(unsigned int * dhcp_use, unsigned int *dhcp_stat);
void Get_IPConfig(char *IP, char * Mask, char *Gateway);
void Set_IPConfig(char *IP, char * Mask, char *Gateway);
void Get_TCPIP_Statistics(Packet_Count * * Packet_Count_Pointer);


//ping api
int Ping_Open(Ping * pingptr, int * errorcode);
int Ping_Close(int sd);
int Ping_Statistics(Ping * pingptr);


//memory
void Get_TCPIP_Memory_Status(unsigned long * total, unsigned long * used);

//route
int  AddDefaultGateway( int interface , unsigned long * Gateway, int * errorcode);
int  DelDefaultGateway(unsigned long * Gateway, int * errorcode);
int  GetDefaultGateway(unsigned long * Gateway, int * errorcode);
int  AddStaticRoute(int interface, Route_Entry * route, int * errorcode);
int  DelStaticRoute(int interface, Route_Entry * route, int * errorcode);



/*************************************************************************/
#endif /* __TCPIP_H__*/
/*************************************************************************/
//end tcpip.h
/*************************************************************************/
