/****************************************************************************
*
* (C) 1999 by BECK IPC GmbH
*
*  BECK IPC GmbH
*  Garbenheimerstr. 38
*  D-35578 Wetzlar
*
*  Phone : (49)-6441-905-240
*  Fax   : (49)-6441-905-245
*
* ---------------------------------------------------------------------------
* Module        : TCPIPAPI.H
* Function      : Constants and datastructures for access to
*                 the Socketinterface
*                 Recommended memory model for applications: LARGE
*
*
* Author        : Bartat
* Date          : 05.10.99
* Version       : V1.00
* ---------------------------------------------------------------------------
* History       :
*
*  Vx.yy        Author  Changes
*
*  V1.00          mb    Create
*                 mb    added tcpinterface
*                 mb    add ppp client API calls
*                 mb    add ppp server API calls
*                 mb    SC12 TCPIP system calls (ip config, DHCP, statistics, IP_TOS)
*                 mb    changed API constants from dec. to hex. (value is the same)
*                 mb    modify struct packet count
*                 mb    add get and set sockopt calls
*                 mb    add ping api calls
*                 mb    add memory information call
*                 mb    modified(rename) members of ppp structures for using PAP and CHAP auth method
*                 mb    add routing calls
*                 mb    add blocking mode call for a sockets
*                 mb    !! important: modified PPPclient_Init structure: set max length of user and password string
*                       to 50 character
*****************************************************************************************************/
#ifndef _TCPIP_API_H__
#define _TCPIP_API_H__
/*****************************************************************************/
/*****************************************************************************/
/*
 * BSD Structure Definitions
 */
/*****************************************************************************/
struct sockaddr
{
	unsigned char  sa_len;      /* Total Length */
	unsigned char  sa_family;   /* Address Family AF_xxx */
	char    sa_data[14]; /* up to 14 bytes of protocol specific address */
};


struct in_addr
{
	unsigned long s_addr; /* 32bit netis/hostid address in network byte order */
};

struct sockaddr_in
{
	short           sin_family; /* AF_INET */
	unsigned int    sin_port;   /* 16bit Port Number in network byte order */
	struct  in_addr sin_addr;   /* 32bit netid/hostid in network byte order */
	char            sin_zero[8];/* unused */
};

/*****************************************************************************/
struct recv_params
{
   char                   *   bufferPtr;
   int                        bufferLength;
   int                        flags;            /*Blocking or  dontwait*/
   struct sockaddr        *   fromPtr;          /* only needed for UDP */
   int                    *   fromlengthPtr;    /* only needed for UDP */
   unsigned long              timeout;          /*timeout milliseconds*/
};

struct send_params
{

   char                   *   bufferPtr;
   int                        bufferLength;
   int                        flags;            /*Blocking or  dontwait*/
   struct sockaddr        *   toPtr;            /* only needed for UDP */
   int                    *   tolengthPtr;      /* only needed for UDP */

};

/*****************************************************************************/
//Set and get socket options structure
/*****************************************************************************/


typedef struct tag_setsockopt{

    int protocol_level;            /*protocol level ip level,tcp level or socket level*/
    int optionName;                /*options name*/
    const char * optionValue;      /* pointer to the option value*/
    int optionLength;              /* length of option value*/

}SetSocketOption;


typedef struct tag_getsockopt{

    int protocol_level;            /*protocol level ip level,tcp level or socket level*/
    int optionName;                /*options name*/
    char       * optionValue;      /* pointer to the option value buffer, where Value can befilled in by the API call */
    int        * optionLength;     /* length of option value buffer*/

}GetSocketOption;

/*****************************************************************************/
//PPP server config information structure
/*****************************************************************************/
typedef struct tag_pppipcfg_data
{
     char IP[16];
     char RemIP[16];
     char Netmask[16];
     char Gateway[16];
     unsigned int  comport;     /* 0==EXT, 1==COM of the SC12*/
     unsigned int  auth;        /* 0==No auth, 1==PAP authentication, 2:CHAP*/
     unsigned int  modem;       /* 0==Nullmodem, 1==usage of modem*/
     unsigned int  flow;
     long          baud;
}PPP_IPCfg_Data;



/*****************************************************************************/
//PPP client structures
/*****************************************************************************/

#define PPP_MAX_DIAL 7


typedef struct tag_pppdial
{
      char  * modemcmd;     //modem command string
      char  * modemans;     //modem answer  string
      int   timeout;        //seconds
      int   retries;
      char  expect_send;
      /*flag:
        expect = 0: pppclient sends modemcmd and expects modemanswer
        expect = 1: pppclient expects modemanswer and sends modemcmd
      */
}PPPDial;


typedef struct tag_pppclie_hangup
{
      char    *modemcmdmode;                 //switch modem into command mode e.g. +++
      int     delay;                         //delay time after switching in seconds
      PPPDial pppdial[PPP_MAX_DIAL];     //modem commands and answer for hangups
}PPP_ModemHangup;




typedef struct tag_ppp_client
{
   /************************************************************************************/
   //user PPP config data
   /************************************************************************************/

   int  port;                     //serial port (0:EXT 1:COM)
   int  auth;                     //authentication (0:disable 1:PAP 2:CHAP)
   int  modem;                    //modem usage (0:nullmodem 1:analogue modem)
   int  flow;                     //serial flow control (0: none, 1:XON/XOFF, 2:RTS/CTS)
   long baud;                     //serial baudrate
   unsigned long idletimeout;     //closing ppp after idle time seconds (0: no closing after idle time)

   char username[50];             //username, if auth ==1 or ==2
   char password[50];             //password, if auth ==1 or ==2

   void * dptr;                   //dummy ptr

   /************************************************************************************/
   //filled in after successful API call: IP cfg data given from server
   /************************************************************************************/
   char PPPClieipAddrStr[16];    //own IP
   char PPPClieRemipAddrStr[16]; //servers IP
   char PPPClienetMaskStr[16];
   char PPPClieipGatewayStr[16];



   /************************************************************************************/
   //modem parameters
   /************************************************************************************/
   PPPDial          pppdial[PPP_MAX_DIAL];       // modem/dial entries
   PPP_ModemHangup  modem_hangup;                    //modem hangup commands




   unsigned int    break_modem;     /*
                                       flag for breaking SC12 <-> modem control communication, dialing, waiting for connect,..
                                       setting break_modem to 1, interrupts current modem communication between
                                       SC12 and the modem at a pppclient open or close call, 
                                       The pppclient read this flag and breaks the modem dialing, or waiting.
                                       This flag could be set from another task, to interrupt the dialing.
                                       If a ppp link  is established, it doesn't break the session.
                                       Don't forget to set this flag to zero after breaking
                                     */

}PPPClient_Init;

/*****************************************************************************/
//TCPIP statistics  structure (needed by function TCPIP_STATISTISTICS 0x74)
/*****************************************************************************/
typedef struct tag_cnt_packet{
      /*recv counter*/
      unsigned int  * cnt_all_packets;   //count all incoming ethernet packets
      unsigned int  * cnt_ip_packets;    //count incoming IP packets
      unsigned int  * cnt_arp_packets;   //count incoming ARP packets
      unsigned int  * cnt_tcp_packets;   //count incoming TCP packets
      unsigned int  * cnt_udp_packets;   //count incoming UDP packets
      unsigned int  * cnt_icmp_packets;  //count incoming ICMP packets
      /*send counter*/
      unsigned int  * cnt_all_sended_packets; //count all sended ethernet packets
      unsigned int  * cnt_ip_sended_packets;//count all sended ip packets
      unsigned int  * cnt_arp_sended_packets; //count all sended arp packets
      unsigned int  * cnt_tcp_sended_packets; //count all sended tcp packets
      unsigned int  * cnt_udp_sended_packets; //count all sended udp packets
      unsigned int  * cnt_icmp_sended_packets;//count all sended icmp packets
      /*chksum error  counter on incoming packets*/
      unsigned int  * cnt_ip_chksum_errs;//count all chksum errors on incoming ip packets
      unsigned int  * cnt_udp_chksum_errs;//count all chksum errors on incoming udp packets
      unsigned int  * cnt_tcp_chksum_errs;//count all chksum errors on incoming tcp packets
      unsigned int  * cnt_eth_errs;//count all ethernet error, CRC, FAE and FIFO overrun
}Packet_Count;


/*****************************************************************************/
//Ping API
/*****************************************************************************/

typedef struct tag_ping_command
{
int    sd;                //socket descriptor, filled by PING_OPEN
char *  remoteHostNamePtr; //remote ip
int     pingInterval;      //seconds
int     pingDataLength;    //max. 1024 Bytes
unsigned long dummy;       //internal value, must be set to zero!!
unsigned char pingstate;   //pin socket state, 1: open 0: closed

//statistics, filled by ping command
unsigned long transmitted; //sended ping requests
unsigned long received;    //received replies
unsigned int lastsenderr;  //last send error
unsigned int lastrcverr;   //last receive error
unsigned long maxRtt;      //Max round trip time, rounded off to 100ms steps
unsigned long minRtt;      //Minimum round trip time in milliseconds, (100 ms steps)
unsigned long lastRtt;     //round trip time (100 ms steps) of the last ping request/reply
}Ping;



/*****************************************************************************/
//Routing
/*****************************************************************************/
typedef struct tag_route_entry{
     unsigned long destIPAddress;  //The IP address to add the route for
     unsigned long destNetmask;    //The netmask for the route
     unsigned long gateway;        //IP address of the gateway of the route
     int hops;                     //Number or routers between this host and route
}Route_Entry;


/*****************************************************************************/
//BSD Socket defines
/*****************************************************************************/

#define AF_INET  2
#define PF_INET  AF_INET

#define SOCK_STREAM     1       /* stream socket   , TCP*/
#define SOCK_DGRAM      2       /* datagram socket , UDP*/

/*****************************************************************************/
#define MSG_BLOCKING          0x0000  /*this message should be blocking */
#define MSG_TIMEOUT           0x0001  /*wake up from recv after we have timed out*/
#define MSG_DONTWAIT          0x0080  /* this message should be nonblocking */

/*****************************************************************************/
//API defines
/*****************************************************************************/

#define API_OPENSOCKET        0x01
#define API_CLOSESOCKET       0x02
#define API_BIND              0x03  /*assign an address to an unnamed socket,port*/
#define API_CONNECT           0x04  /* TCP client only, connect  */
#define API_RECVFROM          0x05  /* UDP recvfrom */
#define API_SENDTO            0x06  /* UDP sendto*/
#define API_HTONS             0x07
#define API_INETADDR          0x08
#define API_SLEEP             0x09
#define API_MALLOC            0x0A
#define API_FREE              0x0B
#define API_GETRCV_BYTES      0x0C
#define API_ACCEPT            0x0D  /* TCP server only  */
#define API_LISTEN            0x0E  /* TCP server only  */
#define API_SEND              0x0F  /* TCP  only  */
#define API_RECV              0x10  /* TCP  only  */
#define API_INETTOASCII       0x11
#define API_RESETCONNECTION   0x12  /* TCP  only  */
#define API_SETLINGER         0x13  /* TCP  only  */
#define API_SETREUSE          0x14  /* TCP server only */
#define API_SETIPTOS          0x15  /* set Type Of Service for a socket */
#define API_SETSOCKOPT        0x16  /* set socket options*/
#define API_GETSOCKOPT        0x17  /* get socket options*/
#define API_SETBLOCKINGMODE   0x18  /*set a socket in blocking or non blocking mode*/

#define PPPCLIENT_INSTALLED   0x40
#define PPPCLIENT_OPEN        0x41
#define PPPCLIENT_CLOSE       0x42
#define PPPCLIENT_GET_STATUS  0x43

//PPP server API calls
#define PPPSERVER_INSTALLED   0x50
#define PPPSERVER_SUSPEND     0x51
#define PPPSERVER_ACTIVATE    0x52
#define PPPSERVER_GET_STATUS  0x53
#define PPPSERVER_GET_CFG     0x54

//Get list of installed servers and devices
#define GET_INSTALLED_SERVERS   0x70

//Reconfigure ethernet interface
#define  REINIT_ETHERNET        0x71

//DHCP usage
#define  DHCP_USE               0x72
#define  DHCP_STAT              0x73
#define  TCPIP_STATISTICS       0x74

//Ping API
#define  PING_OPEN              0x75
#define  PING_CLOSE             0x76
#define  PING_STATISTICS        0x77

//memory
#define  GET_MEMORY_INFO         0x78


//Routing
#define  ADD_DEFAULT_GATEWAY    0x80
#define  DEL_DEFAULT_GATEWAY    0x81
#define  GET_DEFAULT_GATEWAY    0x82
#define  ADD_STATIC_ROUTE       0x83
#define  DEL_STATIC_ROUTE       0x84



/*****************************************************************************/
//Socket options
/*****************************************************************************/
//protocol levels
#define IP_PROTOIP_LEVEL        0       /* ip level     */
#define IP_PROTOTCP_LEVEL       6       /* tcp level    */
#define SOCKET_LEVEL        0x7fff      /* socket level */

//ip level options
#define IPO_TTL               0x0001    /* IP Time to live, default 64 seconds*/
#define IPO_TOS               0x0002    /*IP type of service , default 0*/

//tcp level options
#define TCP_KEEPALIVE       0x4001  /* Set idle time,before sending keepalive probes, default 7200 seconds*/
#define TCP_KEEPALIVE_INTV  0x4004  /* Set keep alive interval probes (default 75 seconds) */
#define TCP_KEEPALIVE_CNT   0x4005  /* Set max. number of keep alive probes, before tcp gives up, default 12*/

//socket level options
#define SO_REUSEADDR       0x0004      /* allow local address reuse ,default 0 disable*/
#define SO_KEEPALIVE       0x0008      /* keep connections alive, default  0 disable*/
#define SO_SNDBUF          0x1001      /* send buffer size, default TCP 4096, UDP 2048 bytes */
#define SO_RCVBUF          0x1002      /* receive buffer size,default TCP 4096, UDP 2048 bytes */

/*****************************************************************************/
//Errorcodes
/*****************************************************************************/
#define API_NOT_SUPPORTED       -2
#define API_ERROR               -1
#define API_ENOERROR             0

//PPP server states
#define PPPS_UNDEFINED      -1    /* Undefined, should not happen*/
#define PPPS_NOT_STARTED     0    /* PPP server was not started*/
#define PPPS_DISABLED        1    /* Server started, but disabled */
#define PPPS_ENABLED         2    /* Server enabled, not connected*/
#define PPPS_LNKUP           3    /* Connection established*/
#define PPPS_MODEMCLOSING    4    /* Server hangs up modem*/
#define PPPS_MODEMINIT       5    /* Server tries init modem*/



//PPP client states
#define PPP_NOTAVAIL    -1     /*Client is not running*/
#define PPP_LNKDOWN     0      /*Link is down*/
#define PPP_LNKWILLOPEN 1      /*will open link*/
#define PPP_LNKUP       2      /*Link is established*/



//PPP client errorcodes
#define PPP_INV_COMPORT  -1    /* invalid comport specified     */
#define PPP_INUSE        -2    /* ppp client already in use     */
#define PPP_INV_USER     -3    /* invalid user or password      */
#define PPP_OPEN_FAIL    -4    /* connection failed             */
#define PPP_INV_DEV      -5    /* pppclient interface not found */
#define PPP_IPCFG_FAIL   -6
#define PPP_CONNECT_FAIL -7


/*****************************************************************************/
#endif _TCPIP_API_H__
/*****************************************************************************/
//end tcpipapi.h
/***************************************************************************/
