/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ScrollPlotJssc
extends JPanel
implements ActionListener {
    static String commName = null;
    JComboBox<String> list = new JComboBox<String>(SerialCommJssc.getPortNames());
    SerialCommJssc comm;
    boolean pause = false;
    ScrollingImage image = null;
    long handle;
    boolean verbose = false;
    Data data = new Data();
    boolean viewStarted = false;

    public static void main(String[] args) {
        ScrollPlotJssc plot = new ScrollPlotJssc(args);
        plot.start();
    }

    public ScrollPlotJssc(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-v")) {
                this.verbose = true;
                continue;
            }
            commName = args[i];
        }
        if (commName != null) {
            this.zzz(5.0);
            this.openComm();
        }
        this.setBackground(Color.black);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    System.out.println("Unable to set look and feel");
                }
                ScrollPlotJssc.this.createImage();
                ScrollPlotJssc.this.viewStarted = true;
                JPanel p = new JPanel();
                p.setLayout(new BorderLayout(5, 5));
                JLabel patternLabel1 = new JLabel("Select a serial port for input");
                if (commName != null) {
                    ScrollPlotJssc.this.list.setSelectedItem(commName);
                    ScrollPlotJssc.this.list.setEnabled(false);
                }
                ScrollPlotJssc.this.list.setEditable(false);
                ScrollPlotJssc.this.list.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        commName = (String)ScrollPlotJssc.this.list.getSelectedItem();
                        ScrollPlotJssc.this.list.setEnabled(false);
                    }
                });
                JPanel p1 = new JPanel();
                p1.setLayout(new BoxLayout(p1, 3));
                p1.add(patternLabel1);
                ScrollPlotJssc.this.list.setAlignmentX(0.0f);
                p1.add(ScrollPlotJssc.this.list);
                p1.setAlignmentX(0.0f);
                p.add((Component)p1, "First");
                p.add((Component)ScrollPlotJssc.this, "Center");
                ScrollPlotJssc.this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                JFrame frame = new JFrame("ComboBoxDemo2");
                frame.setDefaultCloseOperation(3);
                frame.setContentPane(p);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    private void openComm() {
        this.comm = new SerialCommJssc(commName, 115200);
        if (!this.comm.isOpen()) {
            System.out.printf("Cannot open device '%s'\n", commName);
            System.exit(-1);
        }
    }

    void start() {
        while (!this.viewStarted) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            if (ScrollPlotJssc.this.comm == null || !ScrollPlotJssc.this.comm.isOpen()) {
                                ScrollPlotJssc.this.zzz(0.1);
                                continue;
                            }
                            ScrollPlotJssc.this.actionPerformed(null);
                        }
                    }
                    catch (Throwable e) {
                        System.out.println("ERROR: " + e.getMessage());
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    void createImage() {
        this.image = new ScrollingImage(this.getPreferredSize().width, this.getPreferredSize().height);
    }

    public void updateData() {
        if (this.image == null) {
            this.createImage();
        }
        this.image.add();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.image.paint(g);
    }

    static void printHex(byte[] buf, int len) {
        System.out.printf("Buf:", new Object[0]);
        for (int i = 0; i < len; ++i) {
            System.out.printf(" %02x", buf[i] & 0xFF);
        }
        System.out.println();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            String line = this.comm.readLine();
            if (line != null) {
                if (this.verbose) {
                    System.out.println(line);
                }
                if (this.parseLine(line)) {
                    this.updateData();
                    this.update();
                }
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
            e.printStackTrace();
            return;
        }
    }

    private boolean parseLine(String line) {
        try {
            String[] ss = line.split(" ");
            this.data.value = new double[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                int v1 = Integer.parseInt(ss[i]);
                this.data.value[i] = ((double)v1 - (double)this.data.min) / (double)(this.data.max - this.data.min);
            }
            return true;
        }
        catch (NumberFormatException e) {
            System.out.println("ERROR: " + line);
            return false;
        }
    }

    void update() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScrollPlotJssc.this.repaint();
            }
        });
    }

    void zzz(double sec) {
        try {
            Thread.sleep((int)(sec * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(600, 400);
    }

    class ScrollingImage {
        private BufferedImage displayImage;
        private int dataIndex = 0;
        private int numPixels;
        int height;
        int border = 0;
        private int ymin;
        private int ymax;
        private int bgColor = -16777216;
        int borderColor = -8355712;
        private int[] colors = new int[]{-65536, -16711936, -16776961, -256, -65281, -16711681};

        public ScrollingImage(int width, int height) {
            this.numPixels = width;
            this.height = height;
            this.border = 50;
            this.ymin = 0;
            this.ymax = height - 1 - 2 * this.border;
            this.displayImage = new BufferedImage(width, height, 2);
            Graphics2D g = (Graphics2D)this.displayImage.getGraphics();
            g.setColor(new Color(this.bgColor, true));
            g.fillRect(0, 0, width, height);
            g.dispose();
        }

        public void add() {
            this.paint();
            this.dataIndex = (this.dataIndex + 1) % this.numPixels;
        }

        private void paint() {
            int i;
            int x = this.dataIndex;
            for (i = 0; i < this.height; ++i) {
                this.displayImage.setRGB(x, i, this.bgColor);
            }
            this.displayImage.setRGB(x, this.height - this.border, this.borderColor);
            this.displayImage.setRGB(x, this.border - 1, this.borderColor);
            for (i = 0; i < ScrollPlotJssc.this.data.value.length; ++i) {
                int y = (int)((double)this.ymax - ScrollPlotJssc.this.data.value[i] * (double)(this.ymax - this.ymin)) + this.border;
                this.displayImage.setRGB(x, y, this.colors[i]);
            }
        }

        public void paint(Graphics g) {
            g.drawImage(this.displayImage, -this.dataIndex, 0, null);
            g.drawImage(this.displayImage, this.numPixels - this.dataIndex, 0, null);
        }
    }

    class Data {
        double[] value;
        int min = 0;
        int max = 1023;

        Data() {
        }
    }
}

