/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortList;

public class SerialCommJssc {
    private String serialPortName = null;
    private int serialBitRate = -1;
    private InputStream in = null;
    private OutputStream out = null;
    private SerialPort serialPort = null;

    public SerialCommJssc(String name, int bitRate) {
        this.serialPortName = name;
        this.serialBitRate = bitRate;
        try {
            this.connect();
        }
        catch (Exception e) {
            this.in = null;
            this.out = null;
            System.out.println("ERROR: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void connect() {
        SerialPort port = new SerialPort(this.serialPortName);
        try {
            if (!port.openPort()) {
                System.out.println("ERROR cannot open port " + this.serialPortName);
                System.exit(1);
            }
        }
        catch (SerialPortException e) {
            System.out.println("ERROR: " + e.getMessage());
            if (e.getExceptionType().equals("Port busy")) {
                System.out.println("ERROR cannot open port " + this.serialPortName);
                System.exit(2);
            }
            if (e.getExceptionType().equals("Port not found")) {
                System.out.println("ERROR cannot find port " + this.serialPortName);
                System.exit(3);
            }
            System.out.println("ERROR unknown error opening port " + this.serialPortName);
            System.exit(3);
        }
        try {
            port.setParams(this.serialBitRate, 8, 1, 0);
        }
        catch (SerialPortException e) {
            System.out.println("ERROR: " + e.getMessage());
            e.printStackTrace();
        }
        this.serialPort = port;
    }

    public String readLine() {
        StringBuffer sb = new StringBuffer();
        try {
            while (true) {
                if (this.serialPort.getInputBufferBytesCount() == 0) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                byte[] b = this.serialPort.readBytes(1);
                char c = (char)b[0];
                if (c == '\r') continue;
                if (c != '\n') {
                    sb.append(c);
                    continue;
                }
                break;
            }
        }
        catch (SerialPortException e) {
            System.out.println("ERROR: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        return sb.toString();
    }

    public InputStream getInputStream() {
        if (this.in == null) {
            this.in = new InputStream(){

                @Override
                public int read() throws IOException {
                    try {
                        while (SerialCommJssc.this.serialPort.getInputBufferBytesCount() == 0) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        byte[] b = SerialCommJssc.this.serialPort.readBytes(1);
                        return b[0];
                    }
                    catch (SerialPortException e) {
                        System.out.println("ERROR: " + e.getMessage());
                        e.printStackTrace();
                        throw new IOException(e.getMessage());
                    }
                }
            };
        }
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public boolean write(byte[] buffer, int offset, int length) {
        boolean result = false;
        if (length > buffer.length) {
            length = buffer.length - offset;
        }
        try {
            System.out.printf("Writing:", new Object[0]);
            for (int i = offset; i < length; ++i) {
                System.out.printf(" %02x", buffer[i]);
            }
            System.out.printf("\n", new Object[0]);
            this.out.write(buffer, offset, length);
            this.out.flush();
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public int read(byte[] buffer, int offset, int length) {
        int result;
        if (length > buffer.length) {
            length = buffer.length - offset;
        }
        try {
            result = this.in.read(buffer, offset, length);
        }
        catch (Exception e) {
            result = -1;
        }
        return result;
    }

    public boolean isOpen() {
        return this.serialPort != null && this.serialPort.isOpened();
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String[] getPortNames() {
        String[] l = SerialPortList.getPortNames();
        return l;
    }
}

